/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.compat.CloseUtil;

public final class CouchbaseProperties {
    private static Properties fileProperties = new Properties();
    private static final Logger LOGGER = Logger.getLogger(CouchbaseProperties.class.getName());
    private static String namespace = "cbclient";

    private CouchbaseProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPropertyFile(String filename) {
        FileInputStream fs = null;
        try {
            if (filename == null) {
                throw new IllegalArgumentException("Given property filename is null.");
            }
            URL url = ClassLoader.getSystemResource(filename);
            if (url == null) {
                throw new IOException("File not found with system classloader.");
            }
            String clFilename = url.getFile();
            File propFile = new File(clFilename);
            fs = new FileInputStream(propFile);
            fileProperties.load(fs);
            LOGGER.log(Level.INFO, "Successfully loaded properties file \"{0}\".", filename);
            if (fs == null) return;
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.INFO, "Could not load properties file \"{0}\" because: {1}", new Object[]{filename, e.getMessage()});
                if (fs == null) return;
            }
            catch (Throwable throwable) {
                if (fs == null) throw throwable;
                CloseUtil.close(fs);
                throw throwable;
            }
            CloseUtil.close((Closeable)fs);
            return;
        }
        CloseUtil.close((Closeable)fs);
        return;
    }

    public static String getProperty(String name, String def, boolean ignore) {
        String systemProperty;
        if (!ignore) {
            name = namespace + "." + name;
        }
        if ((systemProperty = System.getProperty(name, null)) != null) {
            return systemProperty;
        }
        if (fileProperties != null && fileProperties.getProperty(name, null) != null) {
            return fileProperties.getProperty(name, null);
        }
        return def;
    }

    public static String getProperty(String name, boolean ignore) {
        return CouchbaseProperties.getProperty(name, null, ignore);
    }

    public static String getProperty(String name) {
        return CouchbaseProperties.getProperty(name, null, false);
    }

    public static String getProperty(String name, String def) {
        return CouchbaseProperties.getProperty(name, def, false);
    }

    public static String getNamespace() {
        return namespace;
    }

    public static void setNamespace(String ns) {
        namespace = ns;
    }

    static boolean hasFileProperties() {
        return !fileProperties.isEmpty();
    }

    static void resetFileProperties() {
        fileProperties = new Properties();
    }
}

