/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.RelationId;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Calendard;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.Sized;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.InternalException;

public class RowImpl
implements Row,
Cloneable {
    public static final Object NULL = new Object();
    protected static final int VALID = 2;
    public static final int RAW = Integer.MIN_VALUE;
    protected byte flags = 0;
    private final Column[] _cols;
    private final int _action;
    private final Object[] _vals;
    private final int[] _types;
    private String _sql = null;
    private boolean _isFlushed = false;

    public RowImpl(Table table, int action) {
        this(table.getColumns(), action);
    }

    protected RowImpl(Column[] cols, int action) {
        this._cols = cols;
        this._action = action;
        int len = this._cols.length;
        if (action != 1) {
            len *= 2;
        }
        this._vals = new Object[len];
        this._types = new int[len];
    }

    @Override
    public Table getTable() {
        return this._cols[0].getTable();
    }

    public Column[] getColumns() {
        return this._cols;
    }

    @Override
    public int getAction() {
        return this._action;
    }

    @Override
    public boolean isValid() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setValid(boolean valid) {
        this.flags = valid ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    @Override
    public OpenJPAStateManager getPrimaryKey() {
        return null;
    }

    @Override
    public Object getFailedObject() {
        return null;
    }

    @Override
    public void setFailedObject(Object failed) {
        throw new InternalException();
    }

    public boolean isDependent() {
        return false;
    }

    public Object getSet(Column col) {
        return this._vals[this.getSetIndex(col)];
    }

    public Object getWhere(Column col) {
        return this._vals[this.getWhereIndex(col)];
    }

    @Override
    public void setPrimaryKey(OpenJPAStateManager sm) throws SQLException {
        this.setPrimaryKey(null, sm);
    }

    @Override
    public void setPrimaryKey(ColumnIO io, OpenJPAStateManager sm) throws SQLException {
        this.flushPrimaryKey(sm, io, true);
    }

    @Override
    public void wherePrimaryKey(OpenJPAStateManager sm) throws SQLException {
        this.flushPrimaryKey(sm, null, false);
    }

    private void flushPrimaryKey(OpenJPAStateManager sm, ColumnIO io, boolean set) throws SQLException {
        ClassMapping mapping = (ClassMapping)sm.getMetaData();
        while (mapping.getTable() != this.getTable()) {
            mapping = mapping.getPCSuperclassMapping();
        }
        Column[] cols = mapping.getPrimaryKeyColumns();
        Object oid = mapping.useIdClassFromParent() ? sm.getObjectId() : null;
        this.flushJoinValues(sm, oid, cols, cols, io, set);
    }

    @Override
    public void setForeignKey(ForeignKey fk, OpenJPAStateManager sm) throws SQLException {
        this.setForeignKey(fk, null, sm);
    }

    @Override
    public void setForeignKey(ForeignKey fk, ColumnIO io, OpenJPAStateManager sm) throws SQLException {
        this.flushForeignKey(fk, io, sm, true);
    }

    @Override
    public void whereForeignKey(ForeignKey fk, OpenJPAStateManager sm) throws SQLException {
        this.flushForeignKey(fk, null, sm, false);
    }

    public void clearForeignKey(ForeignKey fk) throws SQLException {
        this._sql = null;
        Column[] cols = fk.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this._vals[this.getSetIndex((Column)cols[i])] = null;
        }
    }

    private void flushForeignKey(ForeignKey fk, ColumnIO io, OpenJPAStateManager sm, boolean set) throws SQLException {
        this.flushJoinValues(sm, null, fk.getPrimaryKeyColumns(), fk.getColumns(), io, set);
        if (sm != null) {
            Column[] cols = fk.getConstantColumns();
            int len = fk.getColumns().length;
            for (int i = 0; i < cols.length; ++i) {
                Object obj = fk.getConstant(cols[i]);
                int type = cols[i].getJavaType();
                if (set && this.canSet(io, i + len, obj == null)) {
                    this.setObject(cols[i], obj, type, false);
                    continue;
                }
                if (set) continue;
                this.whereObject(cols[i], obj, type);
            }
        }
    }

    private void flushJoinValues(OpenJPAStateManager to, Object oid, Column[] toCols, Column[] fromCols, ColumnIO io, boolean set) throws SQLException {
        if (to == null) {
            for (int i = 0; i < fromCols.length; ++i) {
                if (set && this.canSet(io, i, true)) {
                    this.setNull(fromCols[i]);
                    continue;
                }
                if (set) continue;
                this.whereNull(fromCols[i]);
            }
            return;
        }
        if (set && !this.canSetAny(io, fromCols.length, false)) {
            return;
        }
        ClassMapping toMapping = (ClassMapping)to.getMetaData();
        for (int i = 0; i < toCols.length; ++i) {
            if (set && (this._action == 1 && fromCols[i].isAutoAssigned() || !this.canSet(io, i, false))) continue;
            Joinable join = toMapping.assertJoinable(toCols[i]);
            Object val = oid != null ? join.getJoinValue(oid, toCols[i], (JDBCStore)to.getContext().getStoreManager().getInnermostDelegate()) : join.getJoinValue(to, toCols[i], (JDBCStore)to.getContext().getStoreManager().getInnermostDelegate());
            if (set && val == null) {
                if (!this.canSet(io, i, true)) continue;
                this.setNull(fromCols[i]);
                continue;
            }
            if (set && val instanceof Raw) {
                this.setRaw(fromCols[i], val.toString());
                continue;
            }
            if (set) {
                this.setObject(fromCols[i], val, toCols[i].getJavaType(), false);
                continue;
            }
            if (val == null) {
                this.whereNull(fromCols[i]);
                continue;
            }
            if (val instanceof Raw) {
                this.whereRaw(fromCols[i], val.toString());
                continue;
            }
            this.whereObject(fromCols[i], val, toCols[i].getJavaType());
        }
    }

    protected boolean canSetAny(ColumnIO io, int i, boolean nullValue) {
        if (io == null) {
            return true;
        }
        if (this._action == 1) {
            return io.isAnyInsertable(i, nullValue);
        }
        if (this._action == 0) {
            return io.isAnyUpdatable(i, nullValue);
        }
        return true;
    }

    protected boolean canSet(ColumnIO io, int i, boolean nullValue) {
        if (io == null) {
            return true;
        }
        if (this._action == 1) {
            return io.isInsertable(i, nullValue);
        }
        if (this._action == 0) {
            return io.isUpdatable(i, nullValue);
        }
        return true;
    }

    @Override
    public void setRelationId(Column col, OpenJPAStateManager sm, RelationId rel) throws SQLException {
        this.setObject(col, rel.toRelationDataStoreValue(sm, col), col.getJavaType(), false);
    }

    public void clearRelationId(Column col) throws SQLException {
        this._sql = null;
        this._vals[this.getSetIndex((Column)col)] = null;
    }

    @Override
    public void setArray(Column col, Array val) throws SQLException {
        this.setObject(col, val, 11, false);
    }

    @Override
    public void setAsciiStream(Column col, InputStream val, int length) throws SQLException {
        this.setObject(col, val == null ? null : new Sized(val, length), 1001, false);
    }

    @Override
    public void setBigDecimal(Column col, BigDecimal val) throws SQLException {
        this.setObject(col, val, 24, false);
    }

    @Override
    public void setBigInteger(Column col, BigInteger val) throws SQLException {
        this.setObject(col, val, 25, false);
    }

    @Override
    public void setBinaryStream(Column col, InputStream val, int length) throws SQLException {
        this.setObject(col, val == null ? null : new Sized(val, length), 1002, false);
    }

    @Override
    public void setBlob(Column col, Blob val) throws SQLException {
        this.setObject(col, val, 1003, false);
    }

    @Override
    public void setBoolean(Column col, boolean val) throws SQLException {
        this.setObject(col, val ? Boolean.TRUE : Boolean.FALSE, 0, false);
    }

    @Override
    public void setByte(Column col, byte val) throws SQLException {
        this.setObject(col, new Byte(val), 1, false);
    }

    @Override
    public void setBytes(Column col, byte[] val) throws SQLException {
        this.setObject(col, val, 1004, false);
    }

    @Override
    public void setCalendar(Column col, Calendar val) throws SQLException {
        this.setObject(col, val, 28, false);
    }

    @Override
    public void setChar(Column col, char val) throws SQLException {
        this.setObject(col, new Character(val), 2, false);
    }

    @Override
    public void setCharacterStream(Column col, Reader val, int length) throws SQLException {
        this.setObject(col, val == null ? null : new Sized(val, length), 1005, false);
    }

    @Override
    public void setClob(Column col, Clob val) throws SQLException {
        this.setObject(col, val, 1006, false);
    }

    @Override
    public void setDate(Column col, java.util.Date val) throws SQLException {
        this.setObject(col, val, 14, false);
    }

    @Override
    public void setDate(Column col, Date val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.setObject(col, obj, 1007, false);
    }

    @Override
    public void setDouble(Column col, double val) throws SQLException {
        this.setObject(col, new Double(val), 3, false);
    }

    @Override
    public void setFloat(Column col, float val) throws SQLException {
        this.setObject(col, new Float(val), 4, false);
    }

    @Override
    public void setInt(Column col, int val) throws SQLException {
        this.setObject(col, val, 5, false);
    }

    @Override
    public void setLong(Column col, long val) throws SQLException {
        this.setObject(col, val, 6, false);
    }

    @Override
    public void setLocale(Column col, Locale val) throws SQLException {
        this.setObject(col, val, 26, false);
    }

    @Override
    public void setNull(Column col) throws SQLException {
        this.setNull(col, false);
    }

    @Override
    public void setNull(Column col, boolean overrideDefault) throws SQLException {
        this.setObject(col, null, col.getJavaType(), overrideDefault);
    }

    @Override
    public void setNumber(Column col, Number val) throws SQLException {
        this.setObject(col, val, 10, false);
    }

    @Override
    public void setRaw(Column col, String val) throws SQLException {
        this.setObject(col, val, Integer.MIN_VALUE, false);
    }

    @Override
    public void setShort(Column col, short val) throws SQLException {
        this.setObject(col, new Short(val), 7, false);
    }

    @Override
    public void setString(Column col, String val) throws SQLException {
        this.setObject(col, val, 9, false);
    }

    @Override
    public void setTime(Column col, Time val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.setObject(col, obj, 1010, false);
    }

    @Override
    public void setTimestamp(Column col, Timestamp val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.setObject(col, obj, 1011, false);
    }

    @Override
    public void setObject(Column col, Object val) throws SQLException {
        if (val instanceof Raw) {
            this.setObject(col, val, Integer.MIN_VALUE, false);
        } else {
            this.setObject(col, val, col.getJavaType(), false);
        }
    }

    @Override
    public void whereArray(Column col, Array val) throws SQLException {
        this.whereObject(col, val, 1000);
    }

    @Override
    public void whereAsciiStream(Column col, InputStream val, int length) throws SQLException {
        this.whereObject(col, val == null ? null : new Sized(val, length), 1001);
    }

    @Override
    public void whereBigDecimal(Column col, BigDecimal val) throws SQLException {
        this.whereObject(col, val, 24);
    }

    @Override
    public void whereBigInteger(Column col, BigInteger val) throws SQLException {
        this.whereObject(col, val, 25);
    }

    @Override
    public void whereBinaryStream(Column col, InputStream val, int length) throws SQLException {
        this.whereObject(col, val == null ? null : new Sized(val, length), 1002);
    }

    @Override
    public void whereBlob(Column col, Blob val) throws SQLException {
        this.whereObject(col, val, 1003);
    }

    @Override
    public void whereBoolean(Column col, boolean val) throws SQLException {
        this.whereObject(col, val ? Boolean.TRUE : Boolean.FALSE, 0);
    }

    @Override
    public void whereByte(Column col, byte val) throws SQLException {
        this.whereObject(col, new Byte(val), 1);
    }

    @Override
    public void whereBytes(Column col, byte[] val) throws SQLException {
        this.whereObject(col, val, 1004);
    }

    @Override
    public void whereCalendar(Column col, Calendar val) throws SQLException {
        this.whereObject(col, val, 28);
    }

    @Override
    public void whereChar(Column col, char val) throws SQLException {
        this.whereObject(col, new Character(val), 2);
    }

    @Override
    public void whereCharacterStream(Column col, Reader val, int length) throws SQLException {
        this.whereObject(col, val == null ? null : new Sized(val, length), 1005);
    }

    @Override
    public void whereClob(Column col, Clob val) throws SQLException {
        this.whereObject(col, val, 1006);
    }

    @Override
    public void whereDate(Column col, java.util.Date val) throws SQLException {
        this.whereObject(col, val, 14);
    }

    @Override
    public void whereDate(Column col, Date val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.whereObject(col, obj, 1007);
    }

    @Override
    public void whereDouble(Column col, double val) throws SQLException {
        this.whereObject(col, new Double(val), 3);
    }

    @Override
    public void whereFloat(Column col, float val) throws SQLException {
        this.whereObject(col, new Float(val), 4);
    }

    @Override
    public void whereInt(Column col, int val) throws SQLException {
        this.whereObject(col, val, 5);
    }

    @Override
    public void whereLong(Column col, long val) throws SQLException {
        this.whereObject(col, val, 6);
    }

    @Override
    public void whereLocale(Column col, Locale val) throws SQLException {
        this.whereObject(col, val, 26);
    }

    @Override
    public void whereNull(Column col) throws SQLException {
        this.whereObject(col, null, col.getJavaType());
    }

    @Override
    public void whereNumber(Column col, Number val) throws SQLException {
        this.whereObject(col, val, 10);
    }

    @Override
    public void whereRaw(Column col, String val) throws SQLException {
        this.whereObject(col, val, Integer.MIN_VALUE);
    }

    @Override
    public void whereShort(Column col, short val) throws SQLException {
        this.whereObject(col, new Short(val), 7);
    }

    @Override
    public void whereString(Column col, String val) throws SQLException {
        this.whereObject(col, val, 9);
    }

    @Override
    public void whereTime(Column col, Time val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.whereObject(col, obj, 1010);
    }

    @Override
    public void whereTimestamp(Column col, Timestamp val, Calendar cal) throws SQLException {
        Object obj = val == null || cal == null ? val : new Calendard(val, cal);
        this.whereObject(col, obj, 1011);
    }

    @Override
    public void whereObject(Column col, Object val) throws SQLException {
        if (val instanceof Raw) {
            this.whereObject(col, val, Integer.MIN_VALUE);
        } else {
            this.whereObject(col, val, col.getJavaType());
        }
    }

    protected void setObject(Column col, Object val, int metaType, boolean overrideDefault) throws SQLException {
        if (this._action == 1) {
            if (col.isAutoAssigned()) {
                this.setValid(true);
                return;
            }
            if (!overrideDefault && val == null && col.getDefaultString() != null) {
                return;
            }
        }
        this.flush(col, val, metaType, true);
    }

    protected void whereObject(Column col, Object val, int metaType) throws SQLException {
        this.flush(col, val, metaType, false);
    }

    private void flush(Column col, Object val, int metaType, boolean set) {
        int idx = set ? this.getSetIndex(col) : this.getWhereIndex(col);
        this._types[idx] = metaType;
        this._vals[idx] = val == null ? NULL : val;
        if (set || this._action == 2) {
            this.setValid(true);
        }
    }

    public String getSQL(DBDictionary dict) {
        if (!this.isValid()) {
            return "";
        }
        if (this._sql == null) {
            this._sql = this.generateSQL(dict);
        }
        return this._sql;
    }

    protected String generateSQL(DBDictionary dict) {
        switch (this.getAction()) {
            case 0: {
                return this.getUpdateSQL(dict);
            }
            case 1: {
                return this.getInsertSQL(dict);
            }
        }
        return this.getDeleteSQL(dict);
    }

    private String getUpdateSQL(DBDictionary dict) {
        StringBuilder buf = new StringBuilder();
        buf.append("UPDATE ").append(dict.getFullName(this.getTable(), false)).append(" SET ");
        boolean hasVal = false;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._vals[i] == null) continue;
            if (hasVal) {
                buf.append(", ");
            }
            buf.append(dict.getColumnDBName(this._cols[i]));
            if (this._types[i] == Integer.MIN_VALUE) {
                buf.append(" = ").append(this._vals[i]);
            } else {
                buf.append(" = ");
                buf.append(dict.getMarkerForInsertUpdate(this._cols[i], this._vals[i]));
            }
            hasVal = true;
        }
        this.appendWhere(buf, dict);
        return buf.toString();
    }

    private String getInsertSQL(DBDictionary dict) {
        StringBuilder buf = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        buf.append("INSERT INTO ").append(dict.getFullName(this.getTable(), false)).append(" (");
        boolean hasVal = false;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._vals[i] == null) continue;
            if (hasVal) {
                buf.append(", ");
                vals.append(", ");
            }
            buf.append(dict.getColumnDBName(this._cols[i]));
            if (this._types[i] == Integer.MIN_VALUE) {
                vals.append(this._vals[i]);
            } else {
                vals.append(dict.getMarkerForInsertUpdate(this._cols[i], this._vals[i]));
            }
            hasVal = true;
        }
        buf.append(") VALUES (").append(vals.toString()).append(")");
        return buf.toString();
    }

    private String getDeleteSQL(DBDictionary dict) {
        StringBuilder buf = new StringBuilder();
        buf.append("DELETE FROM ").append(dict.getFullName(this.getTable(), false));
        this.appendWhere(buf, dict);
        return buf.toString();
    }

    private void appendWhere(StringBuilder buf, DBDictionary dict) {
        boolean hasWhere = false;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._vals[this.getWhereIndex(this._cols[i])] == null) continue;
            if (!hasWhere) {
                buf.append(" WHERE ");
            } else {
                buf.append(" AND ");
            }
            if (this._cols[i].getVersionStrategy() != null) {
                buf.append(dict.toDBName(dict.getVersionColumn(this._cols[i], this._cols[i].getTableIdentifier()))).append(" = ?");
            } else if (this._vals[this.getWhereIndex(this._cols[i])] == NULL) {
                buf.append(dict.getColumnDBName(this._cols[i])).append(" IS NULL");
            } else if (this._types[i] == Integer.MIN_VALUE) {
                buf.append(dict.getColumnDBName(this._cols[i])).append(" = ").append(this._vals[i]);
            } else {
                buf.append(dict.getColumnDBName(this._cols[i])).append(" = ?");
            }
            hasWhere = true;
        }
    }

    public int getParameterCount() {
        return this._vals.length;
    }

    public void flush(PreparedStatement stmnt, DBDictionary dict, JDBCStore store) throws SQLException {
        this.flush(stmnt, 1, dict, store);
    }

    public void flush(PreparedStatement stmnt, int idx, DBDictionary dict, JDBCStore store) throws SQLException {
        int half = this._vals.length / 2;
        for (int i = this.getAction() == 2 ? this._cols.length : 0; i < this._vals.length; ++i) {
            if (this._vals[i] == null || this._vals[i] == NULL && this.getAction() != 1 && i >= half) continue;
            Column col = i < this._cols.length ? this._cols[i] : this._cols[i - this._cols.length];
            Object val = this._vals[i];
            if (val == NULL) {
                val = null;
            }
            if (val != null && this._types[i] == Integer.MIN_VALUE) continue;
            dict.setTyped(stmnt, idx, val, col, this._types[i], store);
            ++idx;
        }
    }

    private int getSetIndex(Column col) {
        return col.getIndex();
    }

    private int getWhereIndex(Column col) {
        return col.getIndex() + this._cols.length;
    }

    public Object clone() {
        RowImpl clone = this.newInstance(this.getColumns(), this.getAction());
        this.copyInto(clone, false);
        return clone;
    }

    protected RowImpl newInstance(Column[] cols, int action) {
        return new RowImpl(cols, action);
    }

    public void copyInto(RowImpl row, boolean whereOnly) {
        int start;
        int len;
        int action = this.getAction();
        int rowAction = row.getAction();
        if (whereOnly) {
            if (action == 1 || rowAction == 1) {
                len = 0;
                start = 0;
            } else {
                start = len = this._vals.length / 2;
            }
        } else {
            start = 0;
            len = rowAction == 1 && action != 1 ? this._vals.length / 2 : this._vals.length;
        }
        System.arraycopy(this._vals, start, row._vals, start, len);
        System.arraycopy(this._types, start, row._types, start, len);
        if (this.isValid()) {
            row.setValid(true);
        }
    }

    public Object[] getVals() {
        return this._vals;
    }

    public int[] getTypes() {
        return this._types;
    }

    public boolean isFlushed() {
        return this._isFlushed;
    }

    public void setFlushed(boolean isFlushed) {
        this._isFlushed = isFlushed;
    }
}

