/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;

public final class ProcessorExecutor {
    private static final Logger LOGGER = Grizzly.logger(ProcessorExecutor.class);

    public static boolean execute(Connection connection, IOEvent ioEvent, Processor processor, IOEventProcessingHandler processingHandler) throws IOException {
        return ProcessorExecutor.execute(Context.create(connection, processor, ioEvent, processingHandler));
    }

    public static boolean execute(Context context) throws IOException {
        ProcessorResult.Status status;
        boolean isRerun;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "executing connection ({0}). IOEvent={1} processor={2}", new Object[]{context.getConnection(), context.getIoEvent(), context.getProcessor()});
        }
        do {
            ProcessorResult result;
            boolean bl = isRerun = (status = (result = context.getProcessor().process(context)).getStatus()) == ProcessorResult.Status.RERUN;
            if (!isRerun) continue;
            Object resultContext = result.getContext();
            ProcessorExecutor.rerun(context);
            context = (Context)resultContext;
        } while (isRerun);
        switch (status) {
            case COMPLETE: {
                ProcessorExecutor.complete(context);
                return true;
            }
            case LEAVE: {
                ProcessorExecutor.leave(context);
                return false;
            }
            case TERMINATE: {
                ProcessorExecutor.terminate(context);
                return false;
            }
            case REREGISTER: {
                ProcessorExecutor.reregister(context);
                return true;
            }
            case ERROR: {
                ProcessorExecutor.error(context);
                return false;
            }
            case NOT_RUN: {
                ProcessorExecutor.notRun(context);
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean resume(Context context) throws IOException {
        return ProcessorExecutor.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void complete(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onComplete(context);
            }
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void leave(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onLeave(context);
            }
        }
        finally {
            context.recycle();
        }
    }

    private static void reregister(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        if (processingHandler != null) {
            processingHandler.onReregister(context);
        }
    }

    private static void terminate(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        if (processingHandler != null) {
            processingHandler.onTerminate(context);
        }
    }

    private static void rerun(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        if (processingHandler != null) {
            processingHandler.onRerun(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void error(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onError(context);
            }
        }
        finally {
            context.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notRun(Context context) throws IOException {
        IOEventProcessingHandler processingHandler = context.getProcessingHandler();
        try {
            if (processingHandler != null) {
                processingHandler.onNotRun(context);
            }
        }
        finally {
            context.recycle();
        }
    }
}

