/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.synch;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import java.util.LinkedHashMap;

public class OSynchEventAdapter<RESOURCE_TYPE, RESPONSE_TYPE> {
    protected final LinkedHashMap<RESOURCE_TYPE, Object[]> queue = new LinkedHashMap();

    public void registerCallbackCurrentThread(RESOURCE_TYPE iResource) {
        this.queue.put(iResource, new Object[]{iResource, null});
    }

    public RESPONSE_TYPE waitForResource(RESOURCE_TYPE iResource) {
        return this.getValue(iResource, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RESPONSE_TYPE getValue(RESOURCE_TYPE iResource, long iTimeout) {
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Thread [" + Thread.currentThread().getId() + "] is waiting for the resource " + iResource + (iTimeout <= 0L ? " forever" : " until " + iTimeout + "ms"), new Object[0]);
        }
        RESOURCE_TYPE RESOURCE_TYPE = iResource;
        synchronized (RESOURCE_TYPE) {
            try {
                iResource.wait(iTimeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new OLockException("Thread interrupted while waiting for resource '" + iResource + "'");
            }
        }
        Object[] value = (Object[])this.queue.remove(iResource);
        return (RESPONSE_TYPE)(value != null ? value[1] : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(RESOURCE_TYPE iResource, Object iValue) {
        Object[] waiter = this.queue.get(iResource);
        if (waiter == null) {
            return;
        }
        Object object = waiter[0];
        synchronized (object) {
            waiter[1] = iValue;
            waiter[0].notifyAll();
        }
    }
}

