/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;

public class OStringSerializer
implements OBinarySerializer<String> {
    public static final OStringSerializer INSTANCE = new OStringSerializer();
    public static final byte ID = 13;

    @Override
    public int getObjectSize(String object, Object ... hints) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition, Object ... hints) {
        int length = object.length();
        OIntegerSerializer.INSTANCE.serialize(length, stream, startPosition, new Object[0]);
        startPosition += 4;
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        for (char character : stringContent) {
            stream[startPosition] = (byte)character;
            stream[++startPosition] = (byte)(character >>> 8);
            ++startPosition;
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        char[] buffer = new char[len];
        startPosition += 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)(0xFF & stream[startPosition] | (0xFF & stream[startPosition + 1]) << 8);
            startPosition += 2;
        }
        return new String(buffer);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) * 2 + 4;
    }

    @Override
    public void serializeNative(String object, byte[] stream, int startPosition, Object ... hints) {
        int length = object.length();
        OIntegerSerializer.INSTANCE.serializeNative(length, stream, startPosition, new Object[0]);
        startPosition += 4;
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        for (char character : stringContent) {
            stream[startPosition] = (byte)character;
            stream[++startPosition] = (byte)(character >>> 8);
            ++startPosition;
        }
    }

    @Override
    public String deserializeNative(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        char[] buffer = new char[len];
        startPosition += 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)(0xFF & stream[startPosition] | (0xFF & stream[startPosition + 1]) << 8);
            startPosition += 2;
        }
        return new String(buffer);
    }

    @Override
    public void serializeInDirectMemory(String object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        int length = object.length();
        pointer.setInt(offset, length);
        offset += 4L;
        byte[] binaryData = new byte[length * 2];
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        int counter = 0;
        for (char character : stringContent) {
            binaryData[counter] = (byte)character;
            binaryData[++counter] = (byte)(character >>> 8);
            ++counter;
        }
        pointer.set(offset, binaryData, 0, binaryData.length);
    }

    @Override
    public String deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        int len = pointer.getInt(offset);
        char[] buffer = new char[len];
        byte[] binaryData = pointer.get(offset += 4L, buffer.length * 2);
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)(0xFF & binaryData[i << 1] | (0xFF & binaryData[(i << 1) + 1]) << 8);
        }
        return new String(buffer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getInt(offset) * 2 + 4;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        throw new UnsupportedOperationException("Length of serialized string is not fixed.");
    }

    @Override
    public String preprocess(String value, Object ... hints) {
        return value;
    }
}

