/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.util.Map;

public class OSerializationHelper {
    public static final OSerializationHelper INSTANCE = new OSerializationHelper();

    public <K, V> byte[] serialize(Map<K, V> map, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int size = this.length(map, keySerializer, valueSerializer);
        byte[] stream = new byte[size];
        this.serialize(map, stream, 0, keySerializer, valueSerializer);
        return stream;
    }

    private <K, V> void serialize(Map<K, V> map, byte[] stream, int offset, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        OIntegerSerializer.INSTANCE.serialize(map.size(), stream, offset, new Object[0]);
        offset += 4;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keySerializer.serialize(entry.getKey(), stream, offset, new Object[0]);
            valueSerializer.serialize(entry.getValue(), stream, offset += keySerializer.getObjectSize(entry.getKey(), new Object[0]), new Object[0]);
            offset += valueSerializer.getObjectSize(entry.getValue(), new Object[0]);
        }
    }

    public <K, V> int length(Map<K, V> map, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int mapSize = map.size();
        int length = 4;
        assert (keySerializer.isFixedLength());
        length += mapSize * keySerializer.getFixedLength();
        assert (valueSerializer.isFixedLength());
        return length += mapSize * valueSerializer.getFixedLength();
    }
}

