/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.nio.ByteOrder;

public class OFloatSerializer
implements OBinarySerializer<Float> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OFloatSerializer INSTANCE = new OFloatSerializer();
    public static final byte ID = 7;
    public static final int FLOAT_SIZE = 4;

    @Override
    public int getObjectSize(Float object, Object ... hints) {
        return 4;
    }

    @Override
    public void serialize(Float object, byte[] stream, int startPosition, Object ... hints) {
        OIntegerSerializer.INSTANCE.serialize(Float.floatToIntBits(object.floatValue()), stream, startPosition, new Object[0]);
    }

    @Override
    public Float deserialize(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(OIntegerSerializer.INSTANCE.deserialize(stream, startPosition)));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public void serializeNative(Float object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putInt(stream, startPosition, Float.floatToIntBits(object.floatValue()), ByteOrder.nativeOrder());
    }

    @Override
    public Float deserializeNative(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder())));
    }

    @Override
    public void serializeInDirectMemory(Float object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setInt(offset, Float.floatToIntBits(object.floatValue()));
    }

    @Override
    public Float deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return Float.valueOf(Float.intBitsToFloat(pointer.getInt(offset)));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 4;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 4;
    }

    @Override
    public Float preprocess(Float value, Object ... hints) {
        return value;
    }
}

