/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import java.nio.ByteOrder;

public class ODoubleSerializer
implements OBinarySerializer<Double> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static ODoubleSerializer INSTANCE = new ODoubleSerializer();
    public static final byte ID = 6;
    public static final int DOUBLE_SIZE = 8;

    @Override
    public int getObjectSize(Double object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Double object, byte[] stream, int startPosition, Object ... hints) {
        OLongSerializer.INSTANCE.serialize(Double.doubleToLongBits(object), stream, startPosition, new Object[0]);
    }

    @Override
    public Double deserialize(byte[] stream, int startPosition) {
        return Double.longBitsToDouble(OLongSerializer.INSTANCE.deserialize(stream, startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNative(Double object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putLong(stream, startPosition, Double.doubleToLongBits(object), ByteOrder.nativeOrder());
    }

    @Override
    public Double deserializeNative(byte[] stream, int startPosition) {
        return Double.longBitsToDouble(CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder()));
    }

    @Override
    public void serializeInDirectMemory(Double object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setLong(offset, Double.doubleToLongBits(object));
    }

    @Override
    public Double deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return Double.longBitsToDouble(pointer.getLong(offset));
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 8;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Double preprocess(Double value, Object ... hints) {
        return value;
    }
}

