/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;

public class OBooleanSerializer
implements OBinarySerializer<Boolean> {
    public static final int BOOLEAN_SIZE = 1;
    public static OBooleanSerializer INSTANCE = new OBooleanSerializer();
    public static final byte ID = 1;

    @Override
    public int getObjectSize(Boolean object, Object ... hints) {
        return 1;
    }

    @Override
    public void serialize(Boolean object, byte[] stream, int startPosition, Object ... hints) {
        stream[startPosition] = object != false ? (byte)1 : 0;
    }

    @Override
    public Boolean deserialize(byte[] stream, int startPosition) {
        return stream[startPosition] == 1;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 1;
    }

    @Override
    public void serializeNative(Boolean object, byte[] stream, int startPosition, Object ... hints) {
        this.serialize(object, stream, startPosition, new Object[0]);
    }

    @Override
    public Boolean deserializeNative(byte[] stream, int startPosition) {
        return this.deserialize(stream, startPosition);
    }

    @Override
    public void serializeInDirectMemory(Boolean object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        pointer.setByte(offset, object != false ? (byte)1 : 0);
    }

    @Override
    public Boolean deserializeFromDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return pointer.getByte(offset) > 0;
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 1;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 1;
    }

    @Override
    public Boolean preprocess(Boolean value, Object ... hints) {
        return value;
    }
}

