/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.common.profiler.OProfilerMBean;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OProfiler
extends OAbstractProfiler {
    protected final ConcurrentMap<String, Long> counters = new ConcurrentHashMap<String, Long>();

    public OProfiler() {
    }

    public OProfiler(OAbstractProfiler profiler) {
        super(profiler);
    }

    @Override
    public void configure(String iConfiguration) {
        if (iConfiguration == null || iConfiguration.length() == 0) {
            return;
        }
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.startRecording();
    }

    @Override
    public boolean startRecording() {
        if (super.startRecording()) {
            this.counters.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean stopRecording() {
        if (super.stopRecording()) {
            this.counters.clear();
            return true;
        }
        return false;
    }

    @Override
    public void updateCounter(String statName, String description, long plus, String metadata) {
        Long newValue;
        Long oldValue;
        if (statName == null || !this.isRecording()) {
            return;
        }
        do {
            if ((oldValue = (Long)this.counters.get(statName)) != null) continue;
            this.counters.putIfAbsent(statName, 0L);
            oldValue = (Long)this.counters.get(statName);
        } while (!this.counters.replace(statName, oldValue, newValue = Long.valueOf(oldValue + plus)));
    }

    @Override
    public long getCounter(String statName) {
        if (statName == null || !this.isRecording()) {
            return -1L;
        }
        Long stat = (Long)this.counters.get(statName);
        if (stat == null) {
            return -1L;
        }
        return stat;
    }

    @Override
    public String dump() {
        return null;
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        return null;
    }

    @Override
    public String[] getChronosAsString() {
        return null;
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public void setAutoDump(int iNewValue) {
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    @Override
    protected void updateMetadata(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }

    @Override
    public void resetRealtime(String iText) {
    }
}

