/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OCommandStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ODFACommandStream
implements OCommandStream {
    public static final int BUFFER_SIZE = 1024;
    private final Set<Character> separators = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('\n')));
    private Reader reader;
    private CharBuffer buffer;
    private int position;
    private int start;
    private int end;
    private StringBuilder partialResult;
    private State state;

    public ODFACommandStream(String commands) {
        this.reader = new StringReader(commands);
        this.init();
    }

    public ODFACommandStream(File file) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(file));
        this.init();
    }

    @Override
    public boolean hasNext() {
        try {
            this.fillBuffer();
            return this.buffer.hasRemaining();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String nextCommand() {
        try {
            String result;
            this.fillBuffer();
            this.partialResult = new StringBuilder();
            this.state = State.S;
            this.start = 0;
            this.end = -1;
            this.position = 0;
            Symbol s = null;
            while (this.state != State.E) {
                s = this.nextSymbol();
                State newState = this.transition(this.state, s);
                if (this.state == State.S && newState != State.S) {
                    this.start = this.position;
                }
                if (newState == State.A) {
                    this.end = this.position;
                }
                if (newState == State.F) {
                    throw new IllegalStateException("Unexpected end of file");
                }
                this.state = newState;
                ++this.position;
            }
            if (s == Symbol.EOF) {
                --this.position;
                if (this.end == -1) {
                    this.start = 0;
                    this.end = 0;
                }
            }
            if (this.partialResult.length() > 0) {
                if (this.end > 0) {
                    result = this.partialResult.append(this.buffer.subSequence(this.start, this.end + 1).toString()).toString();
                } else {
                    this.partialResult.setLength(this.partialResult.length() + this.end + 1);
                    result = this.partialResult.toString();
                }
            } else {
                CharBuffer cs = this.buffer;
                result = cs.subSequence(this.start, this.end + 1).toString();
            }
            this.buffer.position(this.buffer.position() + this.position);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(boolean onDelete) {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Symbol symbol(Character c) {
        if (c.equals(Character.valueOf('\''))) {
            return Symbol.AP;
        }
        if (c.equals(Character.valueOf('\"'))) {
            return Symbol.QT;
        }
        if (this.separators.contains(c)) {
            return Symbol.SEP;
        }
        if (Character.isWhitespace(c.charValue())) {
            return Symbol.WS;
        }
        return Symbol.LATTER;
    }

    private void init() {
        this.buffer = CharBuffer.allocate(1024);
        this.buffer.flip();
    }

    private void fillBuffer() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.reader.read(this.buffer);
            this.buffer.flip();
        }
    }

    private Symbol nextSymbol() throws IOException {
        Symbol s;
        if (this.buffer.position() + this.position < this.buffer.limit()) {
            s = this.symbol(Character.valueOf(this.buffer.charAt(this.position)));
        } else {
            this.buffer.compact();
            int read = this.reader.read(this.buffer);
            this.buffer.flip();
            if (read == 0) {
                if (this.state != State.S) {
                    this.partialResult.append(this.buffer.subSequence(this.start, this.position).toString());
                }
                this.start = 0;
                this.end -= this.position;
                this.buffer.clear();
                read = this.reader.read(this.buffer);
                this.buffer.flip();
                this.position = 0;
            }
            s = read == -1 ? Symbol.EOF : this.symbol(Character.valueOf(this.buffer.charAt(this.position)));
        }
        return s;
    }

    private State transition(State s, Symbol c) {
        switch (s) {
            case S: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.S;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.S;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case A: 
            case D: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.D;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.E;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case B: {
                switch (c) {
                    case LATTER: {
                        return State.B;
                    }
                    case WS: {
                        return State.B;
                    }
                    case AP: {
                        return State.A;
                    }
                    case QT: {
                        return State.B;
                    }
                    case SEP: {
                        return State.B;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case C: {
                switch (c) {
                    case LATTER: {
                        return State.C;
                    }
                    case WS: {
                        return State.C;
                    }
                    case AP: {
                        return State.C;
                    }
                    case QT: {
                        return State.A;
                    }
                    case SEP: {
                        return State.C;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case E: {
                return State.E;
            }
            case F: {
                return State.F;
            }
        }
        throw new IllegalStateException();
    }

    private static enum Symbol {
        LATTER,
        WS,
        QT,
        AP,
        SEP,
        EOF;

    }

    private static enum State {
        S,
        A,
        B,
        C,
        D,
        E,
        F;

    }
}

