/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OReentrantResourcePool<K, V>
extends OResourcePool<K, V> {
    private final ThreadLocal<Map<K, ResourceHolder<V>>> activeResources = new ThreadLocal();

    public OReentrantResourcePool(int maxResources, OResourcePoolListener<K, V> listener) {
        super(maxResources, listener);
    }

    @Override
    public V getResource(K key, long maxWaitMillis, Object ... additionalArgs) throws OLockException {
        ResourceHolder<V> holder;
        Map resourceHolderMap = this.activeResources.get();
        if (resourceHolderMap == null) {
            resourceHolderMap = new HashMap<K, ResourceHolder<V>>();
            this.activeResources.set(resourceHolderMap);
        }
        if ((holder = resourceHolderMap.get(key)) != null) {
            ((ResourceHolder)holder).counter++;
            return (V)((ResourceHolder)holder).resource;
        }
        try {
            Object res = super.getResource(key, maxWaitMillis, additionalArgs);
            resourceHolderMap.put(key, new ResourceHolder(res));
            return res;
        }
        catch (RuntimeException e) {
            resourceHolderMap.remove(key);
            throw e;
        }
    }

    @Override
    public boolean returnResource(V res) {
        Map<K, ResourceHolder<V>> resourceHolderMap = this.activeResources.get();
        if (resourceHolderMap != null) {
            Object keyToRemove = null;
            for (Map.Entry<K, ResourceHolder<V>> entry : resourceHolderMap.entrySet()) {
                ResourceHolder<V> holder = entry.getValue();
                if (!((ResourceHolder)holder).resource.equals(res)) continue;
                ((ResourceHolder)holder).counter--;
                assert (((ResourceHolder)holder).counter >= 0);
                if (((ResourceHolder)holder).counter > 0) {
                    return false;
                }
                keyToRemove = entry.getKey();
                break;
            }
            resourceHolderMap.remove(keyToRemove);
        }
        return super.returnResource(res);
    }

    public int getConnectionsInCurrentThread(K key) {
        Map<K, ResourceHolder<V>> resourceHolderMap = this.activeResources.get();
        if (resourceHolderMap == null) {
            return 0;
        }
        ResourceHolder<V> holder = resourceHolderMap.get(key);
        if (holder == null) {
            return 0;
        }
        return ((ResourceHolder)holder).counter;
    }

    @Override
    public void remove(V res) {
        this.resources.remove(res);
        ArrayList<K> activeResourcesToRemove = new ArrayList<K>();
        Map<K, ResourceHolder<V>> activeResourcesMap = this.activeResources.get();
        if (activeResourcesMap != null) {
            for (Map.Entry<K, ResourceHolder<V>> entry : activeResourcesMap.entrySet()) {
                ResourceHolder<V> holder = entry.getValue();
                if (!((ResourceHolder)holder).resource.equals(res)) continue;
                activeResourcesToRemove.add(entry.getKey());
            }
            for (Map.Entry<K, ResourceHolder<V>> resourceKey : activeResourcesToRemove) {
                activeResourcesMap.remove(resourceKey);
                this.sem.release();
            }
        }
    }

    private static final class ResourceHolder<V> {
        private final V resource;
        private int counter = 1;

        private ResourceHolder(V resource) {
            this.resource = resource;
        }
    }
}

