/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OCollection;
import com.orientechnologies.common.collection.OIterableObject;
import com.orientechnologies.common.collection.OIterableObjectArray;
import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OMultiValue {
    public static boolean isMultiValue(Class<?> iType) {
        return OCollection.class.isAssignableFrom(iType) || Collection.class.isAssignableFrom(iType) || iType.isArray() || Map.class.isAssignableFrom(iType) || OMultiCollectionIterator.class.isAssignableFrom(iType) || OCollection.class.isAssignableFrom(iType);
    }

    public static boolean isMultiValue(Object iObject) {
        return iObject == null ? false : OMultiValue.isMultiValue(iObject.getClass());
    }

    public static boolean isIterable(Object iObject) {
        return iObject == null ? false : (iObject instanceof Iterable ? true : iObject instanceof Iterator);
    }

    public static int getSize(Object iObject) {
        if (iObject == null) {
            return 0;
        }
        if (iObject instanceof OSizeable) {
            return ((OSizeable)iObject).size();
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return 0;
        }
        if (iObject instanceof Collection) {
            return ((Collection)iObject).size();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).size();
        }
        if (iObject.getClass().isArray()) {
            return Array.getLength(iObject);
        }
        return 0;
    }

    public static Object getFirstValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject) || OMultiValue.getSize(iObject) == 0) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(0);
            }
            if (iObject instanceof Iterable) {
                return ((Iterable)iObject).iterator().next();
            }
            if (iObject instanceof Map) {
                return ((Map)iObject).values().iterator().next();
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, 0);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getLastValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(((List)iObject).size() - 1);
            }
            if (iObject instanceof Iterable) {
                Object last = null;
                for (Object o : (Iterable)iObject) {
                    last = o;
                }
                return last;
            }
            if (iObject instanceof Map) {
                Object last = null;
                for (Object o : ((Map)iObject).values()) {
                    last = o;
                }
                return last;
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, Array.getLength(iObject) - 1);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the last item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getValue(Object iObject, int iIndex) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        if (iIndex > OMultiValue.getSize(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(iIndex);
            }
            if (iObject instanceof Set) {
                int i = 0;
                for (Object o : (Set)iObject) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else if (iObject instanceof Map) {
                int i = 0;
                for (Object o : ((Map)iObject).values()) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else {
                if (iObject.getClass().isArray()) {
                    return Array.get(iObject, iIndex);
                }
                if (iObject instanceof Iterator || iObject instanceof Iterable) {
                    Iterator it = iObject instanceof Iterable ? ((Iterable)iObject).iterator() : (Iterator)iObject;
                    int i = 0;
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (i == iIndex) {
                            if (it instanceof OResettable) {
                                ((OResettable)((Object)it)).reset();
                            }
                            return o;
                        }
                        ++i;
                    }
                    if (it instanceof OResettable) {
                        ((OResettable)((Object)it)).reset();
                    }
                }
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Iterable<Object> getMultiValueIterable(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof Iterable) {
            return (Iterable)iObject;
        }
        if (iObject instanceof Collection) {
            return (Collection)iObject;
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray<Object>(iObject);
        }
        if (iObject instanceof Iterator) {
            ArrayList<Object> temp = new ArrayList<Object>();
            Iterator it = (Iterator)iObject;
            while (it.hasNext()) {
                temp.add(it.next());
            }
            return temp;
        }
        return null;
    }

    public static Iterator<Object> getMultiValueIterator(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof Iterator) {
            return (Iterator)iObject;
        }
        if (iObject instanceof Iterable) {
            return ((Iterable)iObject).iterator();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values().iterator();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray(iObject).iterator();
        }
        return new OIterableObject<Object>(iObject);
    }

    public static String toString(Object iObject) {
        StringBuilder sb = new StringBuilder();
        if (iObject instanceof Iterable) {
            Iterable coll = (Iterable)iObject;
            sb.append('[');
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                try {
                    Object e = it.next();
                    sb.append((Object)(e == iObject ? "(this Collection)" : e));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append(']').toString();
        }
        if (iObject instanceof Map) {
            Map map = (Map)iObject;
            sb.append('{');
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry e = it.next();
                    sb.append((String)e.getKey());
                    sb.append(":");
                    sb.append((Object)(e.getValue() == iObject ? "(this Map)" : e.getValue()));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append('}').toString();
        }
        return iObject.toString();
    }

    public static Object add(Object iObject, Object iToAdd) {
        if (iObject != null) {
            if (!OMultiValue.isMultiValue(iObject)) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(iObject);
            }
            if (iObject instanceof Collection || iObject instanceof OCollection) {
                OCollection coll;
                if (iObject instanceof Collection) {
                    final Collection collection = (Collection)iObject;
                    coll = new OCollection<Object>(){

                        @Override
                        public void add(Object value) {
                            collection.add(value);
                        }

                        @Override
                        public void remove(Object value) {
                            collection.remove(value);
                        }

                        @Override
                        public Iterator<Object> iterator() {
                            return collection.iterator();
                        }

                        @Override
                        public int size() {
                            return collection.size();
                        }
                    };
                } else {
                    coll = (OCollection)iObject;
                }
                if (iToAdd instanceof Iterable) {
                    for (Object o : (Iterable)iToAdd) {
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.add(coll, o);
                            continue;
                        }
                        coll.add(o);
                    }
                } else if (iToAdd != null && iToAdd.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(iToAdd); ++i) {
                        Object o = Array.get(iToAdd, i);
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.add(coll, o);
                            continue;
                        }
                        coll.add(o);
                    }
                } else if (iToAdd instanceof Map) {
                    for (Map.Entry entry : ((Map)iToAdd).entrySet()) {
                        coll.add(entry.getValue());
                    }
                } else if (iToAdd instanceof Iterator) {
                    Iterator it = (Iterator)iToAdd;
                    while (it.hasNext()) {
                        coll.add(it.next());
                    }
                } else {
                    coll.add(iToAdd);
                }
            } else if (iObject.getClass().isArray()) {
                Object[] copy;
                if (iToAdd instanceof Collection) {
                    int tot = Array.getLength(iObject) + ((Collection)iToAdd).size();
                    copy = Arrays.copyOf((Object[])iObject, tot);
                    Iterator it = ((Collection)iToAdd).iterator();
                    for (int i = Array.getLength(iObject); i < tot; ++i) {
                        copy[i] = it.next();
                    }
                } else if (iToAdd != null && iToAdd.getClass().isArray()) {
                    int tot = Array.getLength(iObject) + Array.getLength(iToAdd);
                    copy = Arrays.copyOf((Object[])iObject, tot);
                    System.arraycopy(iToAdd, 0, iObject, Array.getLength(iObject), Array.getLength(iToAdd));
                } else {
                    copy = Arrays.copyOf((Object[])iObject, Array.getLength(iObject) + 1);
                    copy[copy.length - 1] = iToAdd;
                }
                return copy;
            }
        }
        return iObject;
    }

    public static Object remove(Object iObject, Object iToRemove, boolean iAllOccurrences) {
        if (iObject != null) {
            if (iObject instanceof OMultiCollectionIterator) {
                LinkedList list = new LinkedList();
                for (Object o : (OMultiCollectionIterator)((Object)iObject)) {
                    list.add(o);
                }
                iObject = list;
            }
            if (iToRemove instanceof OMultiCollectionIterator) {
                HashSet set = new HashSet();
                for (Object o : (OMultiCollectionIterator)((Object)iToRemove)) {
                    set.add(o);
                }
                iToRemove = set;
            }
            if (iObject instanceof Collection || iObject instanceof OCollection) {
                OCollection coll;
                Object collection;
                if (iObject instanceof Collection) {
                    collection = iObject;
                    coll = new OCollection<Object>((Collection)collection){
                        final /* synthetic */ Collection val$collection;
                        {
                            this.val$collection = collection;
                        }

                        @Override
                        public void add(Object value) {
                            this.val$collection.add(value);
                        }

                        @Override
                        public void remove(Object value) {
                            this.val$collection.remove(value);
                        }

                        @Override
                        public Iterator<Object> iterator() {
                            return this.val$collection.iterator();
                        }

                        @Override
                        public int size() {
                            return this.val$collection.size();
                        }
                    };
                } else {
                    coll = (OCollection)((Object)iObject);
                }
                if (iToRemove instanceof Collection) {
                    for (Object o : (Collection)iToRemove) {
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.remove(coll, o, iAllOccurrences);
                            continue;
                        }
                        coll.remove(o);
                    }
                } else if (iToRemove != null && iToRemove.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(iToRemove); ++i) {
                        Object o;
                        o = Array.get(iToRemove, i);
                        if (OMultiValue.isMultiValue(o)) {
                            OMultiValue.remove(coll, o, iAllOccurrences);
                            continue;
                        }
                        coll.remove(o);
                    }
                } else if (iToRemove instanceof Map) {
                    for (Map.Entry entry : ((Map)((Object)iToRemove)).entrySet()) {
                        coll.remove(entry.getKey());
                    }
                } else if (iToRemove instanceof Iterator) {
                    if (iToRemove instanceof OMultiCollectionIterator) {
                        ((OMultiCollectionIterator)((Object)iToRemove)).reset();
                    }
                    if (iAllOccurrences) {
                        if (iObject instanceof OCollection) {
                            throw new IllegalStateException("Mutable collection can not be used to remove all occurrences.");
                        }
                        collection = iObject;
                        OMultiCollectionIterator it = (OMultiCollectionIterator)((Object)iToRemove);
                        OMultiValue.batchRemove((Collection<Object>)collection, it);
                    } else {
                        Iterator it = (Iterator)((Object)iToRemove);
                        if (it.hasNext()) {
                            Object itemToRemove = it.next();
                            coll.remove(itemToRemove);
                        }
                    }
                } else {
                    coll.remove(iToRemove);
                }
            } else {
                if (iObject.getClass().isArray()) {
                    Object[] copy;
                    if (iToRemove instanceof Collection) {
                        int sourceTot = Array.getLength(iObject);
                        int tot = sourceTot - ((Collection)iToRemove).size();
                        copy = new Object[tot];
                        int k = 0;
                        for (int i = 0; i < sourceTot; ++i) {
                            Object o = Array.get(iObject, i);
                            if (o == null) continue;
                            boolean found = false;
                            for (Object toRemove : (Collection)iToRemove) {
                                if (!o.equals(toRemove)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            copy[k++] = o;
                        }
                    } else {
                        if (iToRemove != null && iToRemove.getClass().isArray()) {
                            throw new UnsupportedOperationException("Cannot execute remove() against an array");
                        }
                        throw new UnsupportedOperationException("Cannot execute remove() against an array");
                    }
                    return copy;
                }
                throw new IllegalArgumentException("Object " + iObject + " is not a multi value");
            }
        }
        return iObject;
    }

    private static void batchRemove(Collection<Object> coll, Iterator<?> it) {
        int approximateRemainingSize = it instanceof OSizeable ? ((OSizeable)((Object)it)).size() : -1;
        while (it.hasNext()) {
            Set<?> batch = OMultiValue.prepareBatch(it, approximateRemainingSize);
            coll.removeAll(batch);
            approximateRemainingSize -= batch.size();
        }
    }

    private static Set<?> prepareBatch(Iterator<?> it, int approximateRemainingSize) {
        HashSet<Object> batch = approximateRemainingSize > -1 ? (approximateRemainingSize > 10000 ? new HashSet(13400) : new HashSet((int)((double)approximateRemainingSize / 0.75))) : new HashSet();
        for (int count = 0; count < 10000 && it.hasNext(); ++count) {
            batch.add(it.next());
        }
        return batch;
    }

    public static Object[] array(Object iValue) {
        return OMultiValue.array(iValue, Object.class);
    }

    public static <T> T[] array(Object iValue, Class<? extends T> iClass) {
        return OMultiValue.array(iValue, iClass, null);
    }

    public static <T> T[] array(Object iValue, Class<? extends T> iClass, OCallable<Object, Object> iCallback) {
        Object[] result;
        if (iValue == null) {
            return null;
        }
        if (OMultiValue.isMultiValue(iValue)) {
            result = (Object[])Array.newInstance(iClass, OMultiValue.getSize(iValue));
            int i = 0;
            Iterator<Object> it = OMultiValue.getMultiValueIterator(iValue);
            while (it.hasNext()) {
                result[i] = OMultiValue.convert(it.next(), iCallback);
                ++i;
            }
        } else if (OMultiValue.isIterable(iValue)) {
            ArrayList<Object> temp = new ArrayList<Object>();
            Iterator<Object> it = OMultiValue.getMultiValueIterator(iValue);
            while (it.hasNext()) {
                temp.add(OMultiValue.convert(it.next(), iCallback));
            }
            result = iClass.equals(Object.class) ? temp.toArray() : temp.toArray((Object[])Array.newInstance(iClass, OMultiValue.getSize(iValue)));
        } else {
            result = (Object[])Array.newInstance(iClass, 1);
            result[0] = OMultiValue.convert(iValue, iCallback);
        }
        return result;
    }

    public static Object convert(Object iObject, OCallable<Object, Object> iCallback) {
        return iCallback != null ? iCallback.call(iObject) : iObject;
    }

    public static boolean equals(Collection<Object> col1, Collection<Object> col2) {
        if (col1.size() != col2.size()) {
            return false;
        }
        return col1.containsAll(col2) && col2.containsAll(col1);
    }
}

