/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.io.NotSerializableException;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.netty.NettyTransport;
import org.elasticsearch.transport.support.TransportStreams;

public class NettyTransportChannel
implements TransportChannel {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final NettyTransport transport;
    private final String action;
    private final Channel channel;
    private final long requestId;

    public NettyTransportChannel(NettyTransport transport, String action, Channel channel, long requestId) {
        this.transport = transport;
        this.action = action;
        this.channel = channel;
        this.requestId = requestId;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(Streamable message) throws IOException {
        this.sendResponse(message, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(Streamable message, TransportResponseOptions options) throws IOException {
        if (this.transport.compress) {
            options.withCompress(true);
        }
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        TransportStreams.buildResponse(cachedEntry, this.requestId, message, options);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(cachedEntry.bytes().underlyingBytes(), 0, cachedEntry.bytes().size());
        ChannelFuture future = this.channel.write(buffer);
        future.addListener(new NettyTransport.CacheFutureListener(cachedEntry));
    }

    @Override
    public void sendResponse(Throwable error) throws IOException {
        BytesStreamOutput stream;
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            stream = cachedEntry.cachedBytes();
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.transport.nodeName(), this.transport.wrapAddress(this.channel.getLocalAddress()), this.action, error);
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        catch (NotSerializableException e) {
            stream = cachedEntry.cachedBytes();
            this.writeResponseExceptionHeader(stream);
            RemoteTransportException tx = new RemoteTransportException(this.transport.nodeName(), this.transport.wrapAddress(this.channel.getLocalAddress()), this.action, new NotSerializableTransportException(error));
            ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
            too.writeObject(tx);
            too.close();
        }
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(stream.underlyingBytes(), 0, stream.size());
        buffer.setInt(0, buffer.writerIndex() - 4);
        ChannelFuture future = this.channel.write(buffer);
        future.addListener(new NettyTransport.CacheFutureListener(cachedEntry));
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeBytes(LENGTH_PLACEHOLDER);
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStreams.statusSetResponse(status);
        status = TransportStreams.statusSetError(status);
        stream.writeByte(status);
    }
}

