/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.internal.SourceFieldSelector;

public class SourceLookup
implements Map {
    private IndexReader reader;
    private int docId = -1;
    private byte[] sourceAsBytes;
    private int sourceAsBytesOffset;
    private int sourceAsBytesLength;
    private Map<String, Object> source;

    public Map<String, Object> source() {
        return this.source;
    }

    private Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            this.source = SourceLookup.sourceAsMap(this.sourceAsBytes, this.sourceAsBytesOffset, this.sourceAsBytesLength);
            return this.source;
        }
        try {
            Document doc = this.reader.document(this.docId, (FieldSelector)SourceFieldSelector.INSTANCE);
            Fieldable sourceField = doc.getFieldable("_source");
            this.source = sourceField == null ? ImmutableMap.of() : SourceLookup.sourceAsMap(sourceField.getBinaryValue(), sourceField.getBinaryOffset(), sourceField.getBinaryLength());
        }
        catch (Exception e) {
            throw new ElasticSearchParseException("failed to parse / load source", e);
        }
        return this.source;
    }

    public static Map<String, Object> sourceAsMap(byte[] bytes, int offset, int length) throws ElasticSearchParseException {
        return XContentHelper.convertToMap(bytes, offset, length, false).v2();
    }

    public void setNextReader(IndexReader reader) {
        if (this.reader == reader) {
            return;
        }
        this.reader = reader;
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = -1;
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.sourceAsBytes = null;
        this.source = null;
    }

    public void setNextSource(byte[] source, int offset, int length) {
        this.sourceAsBytes = source;
        this.sourceAsBytesOffset = offset;
        this.sourceAsBytesLength = length;
    }

    public void setNextSource(Map<String, Object> source) {
        this.source = source;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValues.extractRawValues(path, this.loadSourceIfNeeded());
    }

    public Object filter(String[] includes, String[] excludes) {
        return XContentMapValues.filter(this.loadSourceIfNeeded(), includes, excludes);
    }

    public Object extractValue(String path) {
        return XContentMapValues.extractValue(path, this.loadSourceIfNeeded());
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

