/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.AllButSourceFieldSelector;
import org.elasticsearch.index.mapper.selector.FieldMappersFieldSelector;
import org.elasticsearch.index.mapper.selector.UidAndSourceFieldSelector;
import org.elasticsearch.index.mapper.selector.UidFieldSelector;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FieldsParseElement;
import org.elasticsearch.search.fetch.explain.ExplainFetchSubPhase;
import org.elasticsearch.search.fetch.matchedfilters.MatchedFiltersFetchSubPhase;
import org.elasticsearch.search.fetch.partial.PartialFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.version.VersionFetchSubPhase;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchContext;

public class FetchPhase
implements SearchPhase {
    private final FetchSubPhase[] fetchSubPhases;

    @Inject
    public FetchPhase(HighlightPhase highlightPhase, ScriptFieldsFetchSubPhase scriptFieldsPhase, PartialFieldsFetchSubPhase partialFieldsPhase, MatchedFiltersFetchSubPhase matchFiltersPhase, ExplainFetchSubPhase explainPhase, VersionFetchSubPhase versionPhase) {
        this.fetchSubPhases = new FetchSubPhase[]{scriptFieldsPhase, partialFieldsPhase, matchFiltersPhase, explainPhase, highlightPhase, versionPhase};
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, ? extends SearchParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("fields", new FieldsParseElement());
        for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
            parseElements.putAll(fetchSubPhase.parseElements());
        }
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        ResetFieldSelector fieldSelector;
        ArrayList<String> extractFieldNames = null;
        boolean sourceRequested = false;
        if (!context.hasFieldNames()) {
            if (context.hasPartialFields()) {
                fieldSelector = new UidAndSourceFieldSelector();
                sourceRequested = false;
            } else if (context.hasScriptFields()) {
                fieldSelector = UidFieldSelector.INSTANCE;
                sourceRequested = false;
            } else {
                fieldSelector = new UidAndSourceFieldSelector();
                sourceRequested = true;
            }
        } else if (context.fieldNames().isEmpty()) {
            fieldSelector = UidFieldSelector.INSTANCE;
            sourceRequested = false;
        } else {
            boolean loadAllStored = false;
            FieldMappersFieldSelector fieldSelectorMapper = null;
            for (String fieldName : context.fieldNames()) {
                if (fieldName.equals("*")) {
                    loadAllStored = true;
                    continue;
                }
                if (fieldName.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                FieldMappers x = context.smartNameFieldMappers(fieldName);
                if (x != null && x.mapper().stored()) {
                    if (fieldSelectorMapper == null) {
                        fieldSelectorMapper = new FieldMappersFieldSelector();
                    }
                    fieldSelectorMapper.add(x);
                    continue;
                }
                if (extractFieldNames == null) {
                    extractFieldNames = Lists.newArrayList();
                }
                extractFieldNames.add(fieldName);
            }
            if (loadAllStored) {
                fieldSelector = sourceRequested || extractFieldNames != null ? null : AllButSourceFieldSelector.INSTANCE;
            } else if (fieldSelectorMapper != null) {
                fieldSelectorMapper.add(UidFieldMapper.NAME);
                if (extractFieldNames != null || sourceRequested) {
                    fieldSelectorMapper.add("_source");
                }
                fieldSelector = fieldSelectorMapper;
            } else {
                fieldSelector = extractFieldNames != null || sourceRequested ? new UidAndSourceFieldSelector() : UidFieldSelector.INSTANCE;
            }
        }
        InternalSearchHit[] hits = new InternalSearchHit[context.docIdsToLoadSize()];
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            SearchHitField hitField;
            InternalSearchHit searchHit;
            int docId = context.docIdsToLoad()[context.docIdsToLoadFrom() + index];
            Document doc = this.loadDocument(context, fieldSelector, docId);
            Uid uid = this.extractUid(context, doc, fieldSelector);
            DocumentMapper documentMapper = context.mapperService().documentMapper(uid.type());
            if (documentMapper == null) {
                throw new TypeMissingException(new Index(context.shardTarget().index()), uid.type(), "failed to find type loaded for doc [" + uid.id() + "]");
            }
            byte[] source = this.extractSource(doc, documentMapper);
            hits[index] = searchHit = new InternalSearchHit(docId, uid.id(), uid.type(), (byte[])(sourceRequested ? source : null), null);
            for (Fieldable oField : doc.getFields()) {
                FieldMapper mapper;
                Fieldable field = oField;
                String name = field.name();
                if (name.equals(UidFieldMapper.NAME) || name.equals("_source")) continue;
                Object value = null;
                FieldMappers fieldMappers = documentMapper.mappers().indexName(field.name());
                if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                    name = mapper.names().fullName();
                    value = mapper.valueForSearch(field);
                }
                if (value == null) {
                    value = field.isBinary() ? field.getBinaryValue() : (Object)field.stringValue();
                }
                if (searchHit.fieldsOrNull() == null) {
                    searchHit.fields(new HashMap<String, SearchHitField>(2));
                }
                if ((hitField = searchHit.fields().get(name)) == null) {
                    hitField = new InternalSearchHitField(name, new ArrayList<Object>(2));
                    searchHit.fields().put(name, hitField);
                }
                hitField.values().add(value);
            }
            int readerIndex = context.searcher().readerIndex(docId);
            IndexReader subReader = context.searcher().subReaders()[readerIndex];
            int subDoc = docId - context.searcher().docStarts()[readerIndex];
            context.lookup().setNextReader(subReader);
            context.lookup().setNextDocId(subDoc);
            if (source != null) {
                context.lookup().source().setNextSource(source, 0, source.length);
            }
            if (extractFieldNames != null) {
                for (String extractFieldName : extractFieldNames) {
                    Object value = context.lookup().source().extractValue(extractFieldName);
                    if (value == null) continue;
                    if (searchHit.fieldsOrNull() == null) {
                        searchHit.fields(new HashMap<String, SearchHitField>(2));
                    }
                    if ((hitField = searchHit.fields().get(extractFieldName)) == null) {
                        hitField = new InternalSearchHitField(extractFieldName, new ArrayList<Object>(2));
                        searchHit.fields().put(extractFieldName, hitField);
                    }
                    hitField.values().add(value);
                }
            }
            for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
                FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
                if (!fetchSubPhase.hitExecutionNeeded(context)) continue;
                hitContext.reset(searchHit, subReader, subDoc, context.searcher().getIndexReader(), docId, doc);
                fetchSubPhase.hitExecute(context, hitContext);
            }
        }
        for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
            if (!fetchSubPhase.hitsExecutionNeeded(context)) continue;
            fetchSubPhase.hitsExecute(context, hits);
        }
        context.fetchResult().hits(new InternalSearchHits(hits, context.queryResult().topDocs().totalHits, context.queryResult().topDocs().getMaxScore()));
    }

    private byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        Fieldable sourceField = doc.getFieldable("_source");
        if (sourceField != null) {
            return documentMapper.sourceMapper().nativeValue(sourceField);
        }
        return null;
    }

    private Uid extractUid(SearchContext context, Document doc, @Nullable ResetFieldSelector fieldSelector) {
        String sUid = doc.get(UidFieldMapper.NAME);
        if (sUid != null) {
            return Uid.createUid(sUid);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Fieldable field : doc.getFields()) {
            fieldNames.add(field.name());
        }
        throw new FetchPhaseExecutionException(context, "Failed to load uid from the index, missing internal _uid field, current fields in the doc [" + fieldNames + "], selector [" + fieldSelector + "]");
    }

    private Document loadDocument(SearchContext context, @Nullable ResetFieldSelector fieldSelector, int docId) {
        try {
            if (fieldSelector != null) {
                fieldSelector.reset();
            }
            return context.searcher().doc(docId, fieldSelector);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to fetch doc id [" + docId + "]", (Throwable)e);
        }
    }
}

