/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;

public class QueryFacetBuilder
extends AbstractFacetBuilder {
    private QueryBuilder query;

    public QueryFacetBuilder(String name) {
        super(name);
    }

    @Override
    public QueryFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public QueryFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public QueryFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public QueryFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    public QueryFacetBuilder query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.query == null) {
            throw new SearchSourceBuilderException("query must be set on query facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.field("query");
        this.query.toXContent(builder, params);
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

