/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NestedChildrenCollector;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.FacetProcessors;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.internal.SearchContext;

public class FacetParseElement
implements SearchParseElement {
    private final FacetProcessors facetProcessors;

    @Inject
    public FacetParseElement(FacetProcessors facetProcessors) {
        this.facetProcessors = facetProcessors;
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        ArrayList<FacetCollector> facetCollectors = null;
        String topLevelFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                topLevelFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            FacetCollector facet = null;
            String scope = "_main_";
            String facetFieldName = null;
            Filter filter = null;
            boolean cacheFilter = true;
            String nestedPath = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    facetFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("facet_filter".equals(facetFieldName) || "facetFilter".equals(facetFieldName)) {
                        filter = context.queryParserService().parseInnerFilter(parser);
                        continue;
                    }
                    FacetProcessor facetProcessor = this.facetProcessors.processor(facetFieldName);
                    if (facetProcessor == null) {
                        throw new SearchParseException(context, "No facet type found for [" + facetFieldName + "]");
                    }
                    facet = facetProcessor.parse(topLevelFieldName, parser, context);
                    continue;
                }
                if (!token.isValue()) continue;
                if ("global".equals(facetFieldName)) {
                    if (!parser.booleanValue()) continue;
                    scope = "_global_";
                    continue;
                }
                if ("scope".equals(facetFieldName) || "_scope".equals(facetFieldName)) {
                    scope = parser.text();
                    continue;
                }
                if ("cache_filter".equals(facetFieldName) || "cacheFilter".equals(facetFieldName)) {
                    cacheFilter = parser.booleanValue();
                    continue;
                }
                if (!"nested".equals(facetFieldName)) continue;
                nestedPath = parser.text();
            }
            if (filter != null) {
                if (cacheFilter) {
                    filter = context.filterCache().cache(filter);
                }
                facet.setFilter(filter);
            }
            if (nestedPath != null) {
                MapperService.SmartNameObjectMapper mapper = context.smartNameObjectMapper(nestedPath);
                if (mapper == null) {
                    throw new SearchParseException(context, "facet nested path [" + nestedPath + "] not found");
                }
                ObjectMapper objectMapper = mapper.mapper();
                if (objectMapper == null) {
                    throw new SearchParseException(context, "facet nested path [" + nestedPath + "] not found");
                }
                if (!objectMapper.nested().isNested()) {
                    throw new SearchParseException(context, "facet nested path [" + nestedPath + "] is not nested");
                }
                facet = new NestedChildrenCollector(facet, context.filterCache().cache(NonNestedDocsFilter.INSTANCE), context.filterCache().cache(objectMapper.nestedTypeFilter()));
            }
            if (facet == null) {
                throw new SearchParseException(context, "no facet type found for facet named [" + topLevelFieldName + "]");
            }
            if (facetCollectors == null) {
                facetCollectors = Lists.newArrayList();
            }
            facetCollectors.add(facet);
            context.searcher().addCollector(scope, facet);
        }
        context.facets(new SearchContextFacets(facetCollectors));
    }
}

