/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestFlushAction
extends BaseRestHandler {
    @Inject
    public RestFlushAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_flush", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_flush", this);
        controller.registerHandler(RestRequest.Method.GET, "/_flush", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_flush", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        FlushRequest flushRequest = new FlushRequest(RestActions.splitIndices(request.param("index")));
        flushRequest.listenerThreaded(false);
        BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operationThreading"), BroadcastOperationThreading.SINGLE_THREAD);
        if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
            operationThreading = BroadcastOperationThreading.THREAD_PER_SHARD;
        }
        flushRequest.operationThreading(operationThreading);
        flushRequest.refresh(request.paramAsBoolean("refresh", flushRequest.refresh()));
        flushRequest.full(request.paramAsBoolean("full", flushRequest.full()));
        flushRequest.force(request.paramAsBoolean("force", flushRequest.force()));
        this.client.admin().indices().flush(flushRequest, new ActionListener<FlushResponse>(){

            @Override
            public void onResponse(FlushResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestFlushAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

