/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class OsInfo
implements Streamable,
Serializable,
ToXContent {
    long refreshInterval;
    Cpu cpu = null;
    Mem mem = null;
    Swap swap = null;

    OsInfo() {
    }

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Swap swap() {
        return this.swap;
    }

    public Swap getSwap() {
        return this.swap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.OS);
        builder.field(Fields.REFRESH_INTERVAL, this.refreshInterval);
        if (this.cpu != null) {
            builder.startObject(Fields.CPU);
            builder.field(Fields.VENDOR, this.cpu.vendor());
            builder.field(Fields.MODEL, this.cpu.model());
            builder.field(Fields.MHZ, this.cpu.mhz());
            builder.field(Fields.TOTAL_CORES, this.cpu.totalCores());
            builder.field(Fields.TOTAL_SOCKETS, this.cpu.totalSockets());
            builder.field(Fields.CORES_PER_SOCKET, this.cpu.coresPerSocket());
            builder.field(Fields.CACHE_SIZE, this.cpu.cacheSize().toString());
            builder.field(Fields.CACHE_SIZE_IN_BYTES, this.cpu.cacheSize().bytes());
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.field(Fields.TOTAL, this.mem.total().toString());
            builder.field(Fields.TOTAL_IN_BYTES, this.mem.total);
            builder.endObject();
        }
        if (this.swap != null) {
            builder.startObject(Fields.SWAP);
            builder.field(Fields.TOTAL, this.swap.total().toString());
            builder.field(Fields.TOTAL_IN_BYTES, this.swap.total);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static OsInfo readOsInfo(StreamInput in) throws IOException {
        OsInfo info = new OsInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.swap = Swap.readSwap(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.swap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.swap.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        String vendor = "";
        String model = "";
        int mhz = -1;
        int totalCores = -1;
        int totalSockets = -1;
        int coresPerSocket = -1;
        long cacheSize = -1L;

        Cpu() {
        }

        public String vendor() {
            return this.vendor;
        }

        public String getVendor() {
            return this.vendor();
        }

        public String model() {
            return this.model;
        }

        public String getModel() {
            return this.model;
        }

        public int mhz() {
            return this.mhz;
        }

        public int getMhz() {
            return this.mhz;
        }

        public int totalCores() {
            return this.totalCores;
        }

        public int getTotalCores() {
            return this.totalCores();
        }

        public int totalSockets() {
            return this.totalSockets;
        }

        public int getTotalSockets() {
            return this.totalSockets();
        }

        public int coresPerSocket() {
            return this.coresPerSocket;
        }

        public int getCoresPerSocket() {
            return this.coresPerSocket();
        }

        public ByteSizeValue cacheSize() {
            return new ByteSizeValue(this.cacheSize);
        }

        public ByteSizeValue getCacheSize() {
            return this.cacheSize();
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.vendor = in.readUTF();
            this.model = in.readUTF();
            this.mhz = in.readInt();
            this.totalCores = in.readInt();
            this.totalSockets = in.readInt();
            this.coresPerSocket = in.readInt();
            this.cacheSize = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.vendor);
            out.writeUTF(this.model);
            out.writeInt(this.mhz);
            out.writeInt(this.totalCores);
            out.writeInt(this.totalSockets);
            out.writeInt(this.coresPerSocket);
            out.writeLong(this.cacheSize);
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long total = -1L;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
        }

        public ByteSizeValue total() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getTotal() {
            return this.total();
        }
    }

    public static class Swap
    implements Streamable,
    Serializable {
        long total = -1L;

        Swap() {
        }

        public static Swap readSwap(StreamInput in) throws IOException {
            Swap swap = new Swap();
            swap.readFrom(in);
            return swap;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
        }

        public ByteSizeValue total() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getTotal() {
            return this.total();
        }
    }

    static final class Fields {
        static final XContentBuilderString OS = new XContentBuilderString("os");
        static final XContentBuilderString REFRESH_INTERVAL = new XContentBuilderString("refresh_interval");
        static final XContentBuilderString CPU = new XContentBuilderString("cpu");
        static final XContentBuilderString VENDOR = new XContentBuilderString("vendor");
        static final XContentBuilderString MODEL = new XContentBuilderString("model");
        static final XContentBuilderString MHZ = new XContentBuilderString("mhz");
        static final XContentBuilderString TOTAL_CORES = new XContentBuilderString("total_cores");
        static final XContentBuilderString TOTAL_SOCKETS = new XContentBuilderString("total_sockets");
        static final XContentBuilderString CORES_PER_SOCKET = new XContentBuilderString("cores_per_socket");
        static final XContentBuilderString CACHE_SIZE = new XContentBuilderString("cache_size");
        static final XContentBuilderString CACHE_SIZE_IN_BYTES = new XContentBuilderString("cache_size_in_bytes");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString SWAP = new XContentBuilderString("swap");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");

        Fields() {
        }
    }
}

