/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump.thread;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.dump.Dump;
import org.elasticsearch.monitor.dump.DumpContributionFailedException;
import org.elasticsearch.monitor.dump.DumpContributor;

public class ThreadDumpContributor
implements DumpContributor {
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String THREAD_DUMP = "thread";
    private final String name;

    @Inject
    public ThreadDumpContributor(@Assisted String name, @Assisted Settings settings) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void contribute(Dump dump) throws DumpContributionFailedException {
        PrintWriter writer = new PrintWriter(dump.createFileWriter("threads.txt"));
        try {
            this.processDeadlocks(writer);
            this.processAllThreads(writer);
        }
        catch (Exception e) {
            throw new DumpContributionFailedException(this.getName(), "Failed to generate", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    private void processDeadlocks(PrintWriter dump) {
        dump.println("=====  Deadlocked Threads =====");
        long[] deadlockedThreadIds = this.findDeadlockedThreads();
        if (deadlockedThreadIds != null) {
            this.dumpThreads(dump, this.getThreadInfo(deadlockedThreadIds));
        }
    }

    private void processAllThreads(PrintWriter dump) {
        dump.println();
        dump.println("===== All Threads =====");
        this.dumpThreads(dump, this.dumpAllThreads());
    }

    private void dumpThreads(PrintWriter dump, ThreadInfo[] infos) {
        for (ThreadInfo info : infos) {
            dump.println();
            this.write(info, dump);
        }
    }

    private ThreadInfo[] dumpAllThreads() {
        return threadBean.dumpAllThreads(true, true);
    }

    public long[] findDeadlockedThreads() {
        return threadBean.findDeadlockedThreads();
    }

    public ThreadInfo[] getThreadInfo(long[] threadIds) {
        return threadBean.getThreadInfo(threadIds, true, true);
    }

    private void write(ThreadInfo threadInfo, PrintWriter writer) {
        StackTraceElement[] stackTraceElements;
        writer.print(String.format("\"%s\" Id=%s %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState()}));
        if (threadInfo.getLockName() != null) {
            writer.print(String.format(" on %s", threadInfo.getLockName()));
            if (threadInfo.getLockOwnerName() != null) {
                writer.print(String.format(" owned by \"%s\" Id=%s", threadInfo.getLockOwnerName(), threadInfo.getLockOwnerId()));
            }
        }
        if (threadInfo.isInNative()) {
            writer.println(" (in native)");
        } else {
            writer.println();
        }
        MonitorInfo[] lockedMonitors = threadInfo.getLockedMonitors();
        for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
            writer.println("    at " + stackTraceElement);
            MonitorInfo lockedMonitor = ThreadDumpContributor.findLockedMonitor(stackTraceElement, lockedMonitors);
            if (lockedMonitor == null) continue;
            writer.println("    - locked " + lockedMonitor.getClassName() + "@" + lockedMonitor.getIdentityHashCode());
        }
    }

    private static MonitorInfo findLockedMonitor(StackTraceElement stackTraceElement, MonitorInfo[] lockedMonitors) {
        for (MonitorInfo monitorInfo : lockedMonitors) {
            if (!stackTraceElement.equals(monitorInfo.getLockedStackFrame())) continue;
            return monitorInfo;
        }
        return null;
    }
}

