/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.jmx.action.GetJmxServiceUrlAction;

public class JmxClusterService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final JmxService jmxService;
    private final GetJmxServiceUrlAction getJmxServiceUrlAction;
    private final ExecutorService clusterNodesJmxUpdater;

    public JmxClusterService(Settings settings, ClusterService clusterService, JmxService jmxService, final GetJmxServiceUrlAction getJmxServiceUrlAction) {
        super(settings);
        this.clusterService = clusterService;
        this.jmxService = jmxService;
        this.getJmxServiceUrlAction = getJmxServiceUrlAction;
        this.clusterNodesJmxUpdater = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(settings, "jmxService#updateTask"));
        if (jmxService.publishUrl() != null) {
            clusterService.add(new JmxClusterEventListener());
            for (final DiscoveryNode node : clusterService.state().nodes()) {
                this.clusterNodesJmxUpdater.execute(new Runnable(){

                    @Override
                    public void run() {
                        String nodeServiceUrl = getJmxServiceUrlAction.obtainPublishUrl(node);
                        JmxClusterService.this.registerNode(node, nodeServiceUrl);
                    }
                });
            }
        }
    }

    public void close() {
        if (this.clusterNodesJmxUpdater != null) {
            this.clusterNodesJmxUpdater.shutdownNow();
        }
    }

    private void registerNode(DiscoveryNode node, String nodeServiceUrl) {
        try {
            JMXServiceURL jmxServiceURL = new JMXServiceURL(nodeServiceUrl);
            JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL, null);
            MBeanServerConnection connection = jmxConnector.getMBeanServerConnection();
        }
        catch (Exception e) {
            this.logger.warn("Failed to register node [" + node + "] with serviceUrl [" + nodeServiceUrl + "]", e, new Object[0]);
        }
    }

    private class JmxClusterEventListener
    implements ClusterStateListener {
        private JmxClusterEventListener() {
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!event.nodesChanged()) {
                return;
            }
            for (final DiscoveryNode node : event.nodesDelta().addedNodes()) {
                JmxClusterService.this.clusterNodesJmxUpdater.execute(new Runnable(){

                    @Override
                    public void run() {
                        String nodeServiceUrl = JmxClusterService.this.getJmxServiceUrlAction.obtainPublishUrl(node);
                        JmxClusterService.this.registerNode(node, nodeServiceUrl);
                    }
                });
            }
        }
    }
}

