/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

class RecoveryFileChunkRequest
implements Streamable {
    private ShardId shardId;
    private String name;
    private long position;
    private long length;
    private String checksum;
    private BytesHolder content;

    RecoveryFileChunkRequest() {
    }

    RecoveryFileChunkRequest(ShardId shardId, String name, long position, long length, String checksum, BytesHolder content) {
        this.shardId = shardId;
        this.name = name;
        this.position = position;
        this.length = length;
        this.checksum = checksum;
        this.content = content;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String name() {
        return this.name;
    }

    public long position() {
        return this.position;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public long length() {
        return this.length;
    }

    public BytesHolder content() {
        return this.content;
    }

    public RecoveryFileChunkRequest readFileChunk(StreamInput in) throws IOException {
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest();
        request.readFrom(in);
        return request;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        this.name = in.readUTF();
        this.position = in.readVLong();
        this.length = in.readVLong();
        if (in.readBoolean()) {
            this.checksum = in.readUTF();
        }
        this.content = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeUTF(this.name);
        out.writeVLong(this.position);
        out.writeVLong(this.length);
        if (this.checksum == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.checksum);
        }
        out.writeBytesHolder(this.content);
    }

    public String toString() {
        return this.shardId + ": name='" + this.name + '\'' + ", position=" + this.position + ", length=" + this.length;
    }
}

