/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.cache.filter.weighted.WeightedFilterCache;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.settings.NodeSettingsService;

public class IndicesFilterCache
extends AbstractComponent
implements RemovalListener<WeightedFilterCache.FilterCacheKey, DocSet> {
    private Cache<WeightedFilterCache.FilterCacheKey, DocSet> cache;
    private volatile String size;
    private volatile long sizeInBytes;
    private volatile TimeValue expire;
    private volatile Map<String, RemovalListener<WeightedFilterCache.FilterCacheKey, DocSet>> removalListeners = ImmutableMap.of();

    @Inject
    public IndicesFilterCache(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.size = this.componentSettings.get("size", "20%");
        this.expire = this.componentSettings.getAsTime("expire", null);
        this.computeSizeInBytes();
        this.buildCache();
        this.logger.debug("using [node] filter cache with size [{}], actual_size [{}]", this.size, new ByteSizeValue(this.sizeInBytes));
        nodeSettingsService.addListener(new ApplySettings());
    }

    private void buildCache() {
        CacheBuilder<WeightedFilterCache.FilterCacheKey, DocSet> cacheBuilder = CacheBuilder.newBuilder().removalListener(this).maximumWeight(this.sizeInBytes).weigher(new WeightedFilterCache.FilterCacheValueWeigher());
        cacheBuilder.concurrencyLevel(8);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    private void computeSizeInBytes() {
        if (this.size.endsWith("%")) {
            double percent = Double.parseDouble(this.size.substring(0, this.size.length() - 1));
            this.sizeInBytes = (long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes());
        } else {
            this.sizeInBytes = ByteSizeValue.parseBytesSizeValue(this.size).bytes();
        }
    }

    public synchronized void addRemovalListener(String index, RemovalListener<WeightedFilterCache.FilterCacheKey, DocSet> listener) {
        this.removalListeners = MapBuilder.newMapBuilder(this.removalListeners).put(index, listener).immutableMap();
    }

    public synchronized void removeRemovalListener(String index) {
        this.removalListeners = MapBuilder.newMapBuilder(this.removalListeners).remove(index).immutableMap();
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public Cache<WeightedFilterCache.FilterCacheKey, DocSet> cache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<WeightedFilterCache.FilterCacheKey, DocSet> removalNotification) {
        WeightedFilterCache.FilterCacheKey key = removalNotification.getKey();
        if (key == null) {
            return;
        }
        RemovalListener<WeightedFilterCache.FilterCacheKey, DocSet> listener = this.removalListeners.get(key.index());
        if (listener != null) {
            listener.onRemoval(removalNotification);
        }
    }

    static {
        MetaData.addDynamicSettings("indices.cache.filter.size", "indices.cache.filter.expire");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue expire;
            boolean replace = false;
            String size = settings.get("indices.cache.filter.size", IndicesFilterCache.this.size);
            if (!size.equals(IndicesFilterCache.this.size)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.size] from [{}] to [{}]", IndicesFilterCache.this.size, size);
                IndicesFilterCache.this.size = size;
                replace = true;
            }
            if (!Objects.equal(expire = settings.getAsTime("indices.cache.filter.expire", IndicesFilterCache.this.expire), IndicesFilterCache.this.expire)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.expire] from [{}] to [{}]", IndicesFilterCache.this.expire, expire);
                IndicesFilterCache.this.expire = expire;
                replace = true;
            }
            if (replace) {
                Cache oldCache = IndicesFilterCache.this.cache;
                IndicesFilterCache.this.computeSizeInBytes();
                IndicesFilterCache.this.buildCache();
                oldCache.invalidateAll();
            }
        }
    }
}

