/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.BytesWrap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.SearchContext;

public class ChildCollector
extends Collector {
    private final String parentType;
    private final SearchContext context;
    private final Tuple<IndexReader, IdReaderTypeCache>[] readers;
    private final Map<Object, FixedBitSet> parentDocs;
    private IdReaderTypeCache typeCache;

    public ChildCollector(String parentType, SearchContext context) {
        this.parentType = parentType;
        this.context = context;
        this.parentDocs = new HashMap<Object, FixedBitSet>();
        this.readers = new Tuple[context.searcher().subReaders().length];
        for (int i = 0; i < this.readers.length; ++i) {
            IndexReader reader = context.searcher().subReaders()[i];
            this.readers[i] = new Tuple<IndexReader, IdReaderTypeCache>(reader, context.idCache().reader(reader).type(parentType));
        }
    }

    public Map<Object, FixedBitSet> parentDocs() {
        return this.parentDocs;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        BytesWrap parentId = this.typeCache.parentIdByDoc(doc);
        if (parentId == null) {
            return;
        }
        for (Tuple<IndexReader, IdReaderTypeCache> tuple : this.readers) {
            int parentDocId;
            IndexReader indexReader = tuple.v1();
            IdReaderTypeCache idReaderTypeCache = tuple.v2();
            if (idReaderTypeCache == null || (parentDocId = idReaderTypeCache.docById(parentId)) == -1 || indexReader.isDeleted(parentDocId)) continue;
            FixedBitSet docIdSet = this.parentDocs().get(indexReader.getCoreCacheKey());
            if (docIdSet == null) {
                docIdSet = new FixedBitSet(indexReader.maxDoc());
                this.parentDocs.put(indexReader.getCoreCacheKey(), docIdSet);
            }
            docIdSet.set(parentDocId);
            return;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.typeCache = this.context.idCache().reader(reader).type(this.parentType);
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

