/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class WildcardQueryParser
implements QueryParser {
    public static final String NAME = "wildcard";

    @Inject
    public WildcardQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[wildcard] query malformed, no field");
        }
        String fieldName = parser.currentName();
        String rewriteMethod = null;
        String value = null;
        float boost = 1.0f;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (NAME.equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("rewrite".equals(currentFieldName)) {
                    rewriteMethod = parser.textOrNull();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[wildcard] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.text();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for prefix query");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            fieldName = smartNameFieldMappers.mapper().names().indexName();
            value = smartNameFieldMappers.mapper().indexedValue(value);
        }
        WildcardQuery query = new WildcardQuery(new Term(fieldName, value));
        QueryParsers.setRewriteMethod((MultiTermQuery)query, rewriteMethod);
        query.setRewriteMethod(QueryParsers.parseRewriteMethod(rewriteMethod));
        query.setBoost(boost);
        return QueryParsers.wrapSmartNameQuery((Query)query, smartNameFieldMappers, parseContext);
    }
}

