/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoPolygonFilter;
import org.elasticsearch.index.search.geo.GeoUtils;
import org.elasticsearch.index.search.geo.Point;

public class GeoPolygonFilterParser
implements FilterParser {
    public static final String NAME = "geo_polygon";

    @Inject
    public GeoPolygonFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoPolygon"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        ArrayList<Point> points = Lists.newArrayList();
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    if ("points".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            Point point;
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                point = new Point();
                                token = parser.nextToken();
                                point.lon = parser.doubleValue();
                                token = parser.nextToken();
                                point.lat = parser.doubleValue();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                }
                                points.add(point);
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                point = new Point();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        currentFieldName = parser.currentName();
                                        continue;
                                    }
                                    if (!token.isValue()) continue;
                                    if (currentFieldName.equals("lat")) {
                                        point.lat = parser.doubleValue();
                                        continue;
                                    }
                                    if (currentFieldName.equals("lon")) {
                                        point.lon = parser.doubleValue();
                                        continue;
                                    }
                                    if (!currentFieldName.equals("geohash")) continue;
                                    double[] values = GeoHashUtils.decode(parser.text());
                                    point.lat = values[0];
                                    point.lon = values[1];
                                }
                                points.add(point);
                                continue;
                            }
                            if (!token.isValue()) continue;
                            point = new Point();
                            String value = parser.text();
                            int comma = value.indexOf(44);
                            if (comma != -1) {
                                point.lat = Double.parseDouble(value.substring(0, comma).trim());
                                point.lon = Double.parseDouble(value.substring(comma + 1).trim());
                            } else {
                                double[] values = GeoHashUtils.decode(value);
                                point.lat = values[0];
                                point.lon = values[1];
                            }
                            points.add(point);
                        }
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[geo_polygon] filter does not support [" + currentFieldName + "]");
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("normalize".equals(currentFieldName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[geo_polygon] filter does not support [" + currentFieldName + "]");
        }
        if (points.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "no points defined for geo_polygon filter");
        }
        if (normalizeLat || normalizeLon) {
            for (Point point : points) {
                GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            }
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        fieldName = mapper.names().indexName();
        GeoPolygonFilter filter = new GeoPolygonFilter(points.toArray(new Point[points.size()]), fieldName, parseContext.indexCache().fieldData());
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

