/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class BooleanFieldMapper
extends AbstractFieldMapper<Boolean> {
    public static final String CONTENT_TYPE = "boolean";
    private Boolean nullValue;

    protected BooleanFieldMapper(FieldMapper.Names names, Field.Index index, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Boolean nullValue) {
        super(names, index, store, termVector, boost, omitNorms, omitTermFreqAndPositions, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.nullValue = nullValue;
    }

    @Override
    public boolean useFieldQueryWithQueryString() {
        return true;
    }

    @Override
    public Boolean value(Fieldable field) {
        return field.stringValue().charAt(0) == 'T' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean valueFromString(String value) {
        return value.charAt(0) == 'T' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return field.stringValue().charAt(0) == 'T' ? "true" : "false";
    }

    @Override
    public String indexedValue(String value) {
        if (value == null || value.length() == 0) {
            return "F";
        }
        if (value.length() == 1 && value.charAt(0) == 'F') {
            return "F";
        }
        if (Booleans.parseBoolean(value, false)) {
            return "T";
        }
        return "F";
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return new TermFilter(this.names().createIndexNameTerm(this.nullValue != false ? "T" : "F"));
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.indexed() && !this.stored()) {
            return null;
        }
        XContentParser.Token token = context.parser().currentToken();
        String value = null;
        if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                value = this.nullValue != false ? "T" : "F";
            }
        } else {
            String string = value = context.parser().booleanValue() ? "T" : "F";
        }
        if (value == null) {
            return null;
        }
        return new Field(this.names.indexName(), value, this.store, this.index, this.termVector);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.nullValue != null) {
            builder.field("null_value", (Object)this.nullValue);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.booleanField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeBooleanValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BooleanFieldMapper> {
        private Boolean nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.omitNorms = true;
            this.builder = this;
        }

        public Builder nullValue(boolean nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Builder index(Field.Index index) {
            return (Builder)super.index(index);
        }

        @Override
        public Builder store(Field.Store store) {
            return (Builder)super.store(store);
        }

        @Override
        public Builder termVector(Field.TermVector termVector) {
            return (Builder)super.termVector(termVector);
        }

        @Override
        public Builder boost(float boost) {
            return (Builder)super.boost(boost);
        }

        @Override
        public Builder indexName(String indexName) {
            return (Builder)super.indexName(indexName);
        }

        @Override
        public Builder omitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
            return (Builder)super.omitTermFreqAndPositions(omitTermFreqAndPositions);
        }

        @Override
        public BooleanFieldMapper build(Mapper.BuilderContext context) {
            return new BooleanFieldMapper(this.buildNames(context), this.index, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final boolean OMIT_NORMS = true;
        public static final Boolean NULL_VALUE = null;
    }
}

