/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.FieldMappersFieldSelector;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class ShardGetService
extends AbstractIndexShardComponent {
    private final ScriptService scriptService;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private IndexShard indexShard;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardGetService(ShardId shardId, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexCache indexCache) {
        super(shardId, indexSettings);
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.indexCache = indexCache;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public ShardGetService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime);
            if (getResult.exists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult innerGet(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        DocumentMapper docMapper;
        boolean loadSource = gFields == null || gFields.length > 0;
        Engine.GetResult get = null;
        if (type == null || type.equals("_all")) {
            for (String typeX : this.mapperService.types()) {
                get = this.indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(typeX, id))).loadSource(loadSource));
                if (get.exists()) {
                    type = typeX;
                    break;
                }
                get.release();
            }
            if (get == null) {
                return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
            }
            if (!get.exists()) {
                return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
            }
        } else {
            get = this.indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(type, id))).loadSource(loadSource));
            if (!get.exists()) {
                get.release();
                return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
            }
        }
        if ((docMapper = this.mapperService.documentMapper(type)) == null) {
            get.release();
            return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
        }
        try {
            if (get.docIdAndVersion() != null) {
                Object searchLookup;
                Object value;
                HashMap<String, GetField> fields = null;
                byte[] source = null;
                UidField.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
                ResetFieldSelector fieldSelector = ShardGetService.buildFieldSelectors(docMapper, gFields);
                if (fieldSelector != null) {
                    Document doc;
                    fieldSelector.reset();
                    try {
                        doc = docIdAndVersion.reader.document(docIdAndVersion.docId, (FieldSelector)fieldSelector);
                    }
                    catch (IOException e) {
                        throw new ElasticSearchException("Failed to get type [" + type + "] and id [" + id + "]", e);
                    }
                    source = ShardGetService.extractSource(doc, docMapper);
                    Iterator i$ = doc.getFields().iterator();
                    while (i$.hasNext()) {
                        GetField getField;
                        FieldMapper mapper;
                        Fieldable oField;
                        Fieldable field = oField = (Fieldable)i$.next();
                        String name = field.name();
                        value = null;
                        FieldMappers fieldMappers = docMapper.mappers().indexName(field.name());
                        if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                            name = mapper.names().fullName();
                            value = mapper.valueForSearch(field);
                        }
                        if (value == null) {
                            value = field.isBinary() ? (Object)field.getBinaryValue() : field.stringValue();
                        }
                        if (fields == null) {
                            fields = Maps.newHashMapWithExpectedSize(2);
                        }
                        if ((getField = (GetField)fields.get(name)) == null) {
                            getField = new GetField(name, new ArrayList<Object>(2));
                            fields.put(name, getField);
                        }
                        getField.values().add(value);
                    }
                }
                if (gFields != null && gFields.length > 0) {
                    searchLookup = null;
                    for (String field : gFields) {
                        GetField getField;
                        value = null;
                        if (field.contains("_source.") || field.contains("doc[")) {
                            if (searchLookup == null) {
                                searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type});
                            }
                            SearchScript searchScript = this.scriptService.search((SearchLookup)searchLookup, "mvel", field, null);
                            searchScript.setNextReader(docIdAndVersion.reader);
                            searchScript.setNextDocId(docIdAndVersion.docId);
                            try {
                                value = searchScript.run();
                            }
                            catch (RuntimeException e) {
                                if (this.logger.isTraceEnabled()) {
                                    this.logger.trace("failed to execute get request script field [{}]", e, field);
                                }
                            }
                        } else {
                            FieldMappers x = docMapper.mappers().smartName(field);
                            if (x == null || !x.mapper().stored()) {
                                if (searchLookup == null) {
                                    searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type});
                                    ((SearchLookup)searchLookup).setNextReader(docIdAndVersion.reader);
                                    ((SearchLookup)searchLookup).setNextDocId(docIdAndVersion.docId);
                                }
                                value = ((SearchLookup)searchLookup).source().extractValue(field);
                            }
                        }
                        if (value == null) continue;
                        if (fields == null) {
                            fields = Maps.newHashMapWithExpectedSize(2);
                        }
                        if ((getField = (GetField)fields.get(field)) == null) {
                            getField = new GetField(field, new ArrayList<Object>(2));
                            fields.put(field, getField);
                        }
                        getField.values().add(value);
                    }
                }
                searchLookup = new GetResult(this.shardId.index().name(), type, id, get.version(), get.exists(), source == null ? null : new BytesHolder(source), fields);
                return searchLookup;
            }
            Translog.Source source = get.source();
            HashMap<String, GetField> fields = null;
            boolean sourceRequested = false;
            if (gFields == null) {
                sourceRequested = true;
            } else if (gFields.length == 0) {
                sourceRequested = false;
            } else {
                Map<String, Object> sourceAsMap = null;
                SearchLookup searchLookup = null;
                for (String field : gFields) {
                    GetField getField;
                    if (field.equals("_source")) {
                        sourceRequested = true;
                        continue;
                    }
                    Object value = null;
                    if (field.equals("_routing") && docMapper.routingFieldMapper().stored()) {
                        value = source.routing;
                    } else if (field.equals("_parent") && docMapper.parentFieldMapper() != null && docMapper.parentFieldMapper().stored()) {
                        value = source.parent;
                    } else if (field.equals("_timestamp") && docMapper.timestampFieldMapper().stored()) {
                        value = source.timestamp;
                    } else if (field.equals("_ttl") && docMapper.TTLFieldMapper().stored()) {
                        if (source.ttl > 0L) {
                            value = docMapper.TTLFieldMapper().valueForSearch(source.timestamp + source.ttl);
                        }
                    } else if (field.equals("_size") && docMapper.rootMapper(SizeFieldMapper.class).stored()) {
                        value = source.source.length();
                    } else if (field.contains("_source.")) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type});
                        }
                        if (sourceAsMap == null) {
                            sourceAsMap = SourceLookup.sourceAsMap(source.source.bytes(), source.source.offset(), source.source.length());
                        }
                        SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field, null);
                        searchScript.setNextSource(sourceAsMap);
                        try {
                            value = searchScript.run();
                        }
                        catch (RuntimeException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("failed to execute get request script field [{}]", e, field);
                            }
                        }
                    } else {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.indexCache.fieldData(), new String[]{type});
                            searchLookup.source().setNextSource(source.source.bytes(), source.source.offset(), source.source.length());
                        }
                        FieldMapper x = docMapper.mappers().smartNameFieldMapper(field);
                        if (docMapper.sourceMapper().enabled() || x == null || x.stored()) {
                            value = searchLookup.source().extractValue(field);
                            if (x != null && value instanceof String) {
                                value = x.valueFromString((String)value);
                            }
                        }
                    }
                    if (value == null) continue;
                    if (fields == null) {
                        fields = Maps.newHashMapWithExpectedSize(2);
                    }
                    if ((getField = (GetField)fields.get(field)) == null) {
                        getField = new GetField(field, new ArrayList<Object>(2));
                        fields.put(field, getField);
                    }
                    getField.values().add(value);
                }
            }
            if (sourceRequested && !docMapper.sourceMapper().enabled()) {
                sourceRequested = false;
            }
            GetResult getResult = new GetResult(this.shardId.index().name(), type, id, get.version(), get.exists(), sourceRequested ? source.source : null, fields);
            return getResult;
        }
        finally {
            get.release();
        }
    }

    private static ResetFieldSelector buildFieldSelectors(DocumentMapper docMapper, String ... fields) {
        if (fields == null) {
            return docMapper.sourceMapper().fieldSelector();
        }
        if (fields.length == 0) {
            return null;
        }
        FieldMappersFieldSelector fieldSelector = null;
        for (String fieldName : fields) {
            FieldMappers x = docMapper.mappers().smartName(fieldName);
            if (x == null || !x.mapper().stored()) continue;
            if (fieldSelector == null) {
                fieldSelector = new FieldMappersFieldSelector();
            }
            fieldSelector.add(x);
        }
        return fieldSelector;
    }

    private static byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        byte[] source = null;
        Fieldable sourceField = doc.getFieldable(documentMapper.sourceMapper().names().indexName());
        if (sourceField != null) {
            source = documentMapper.sourceMapper().nativeValue(sourceField);
            doc.removeField(documentMapper.sourceMapper().names().indexName());
        }
        return source;
    }
}

