/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.local;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Closeables;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.RecoveryStatus;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsTranslog;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final ThreadPool threadPool;
    private final InternalIndexShard indexShard;
    private final RecoveryStatus recoveryStatus = new RecoveryStatus();
    private volatile ScheduledFuture flushScheduler;
    private final TimeValue syncInterval;

    @Inject
    public LocalIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexShard = (InternalIndexShard)indexShard;
        this.syncInterval = this.componentSettings.getAsTime("sync", TimeValue.timeValueSeconds(5L));
        if (this.syncInterval.millis() > 0L) {
            this.indexShard.translog().syncOnEachOperation(false);
            this.flushScheduler = threadPool.schedule(this.syncInterval, "same", new Sync());
        } else if (this.syncInterval.millis() == 0L) {
            this.flushScheduler = null;
            this.indexShard.translog().syncOnEachOperation(true);
        } else {
            this.flushScheduler = null;
        }
    }

    public String toString() {
        return "local";
    }

    @Override
    public RecoveryStatus recoveryStatus() {
        return this.recoveryStatus;
    }

    @Override
    public void recover(boolean indexShouldExists, RecoveryStatus recoveryStatus) throws IndexShardGatewayRecoveryException {
        recoveryStatus.index().startTime(System.currentTimeMillis());
        recoveryStatus.updateStage(RecoveryStatus.Stage.INDEX);
        long version = -1L;
        long translogId = -1L;
        try {
            if (IndexReader.indexExists((Directory)this.indexShard.store().directory())) {
                if (indexShouldExists) {
                    version = IndexReader.getCurrentVersion((Directory)this.indexShard.store().directory());
                    Map commitUserData = IndexReader.getCommitUserData((Directory)this.indexShard.store().directory());
                    translogId = commitUserData.containsKey("translog_id") ? Long.parseLong((String)commitUserData.get("translog_id")) : version;
                    this.logger.trace("using existing shard data, translog id [{}]", translogId);
                } else {
                    this.logger.trace("cleaning existing shard, shouldn't exists", new Object[0]);
                    IndexWriter writer = new IndexWriter(this.indexShard.store().directory(), new IndexWriterConfig(Lucene.VERSION, (Analyzer)Lucene.STANDARD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                    writer.close();
                }
            } else if (indexShouldExists && this.indexShard.store().indexStore().persistent()) {
                throw new IndexShardGatewayRecoveryException(this.shardId(), "shard allocated for local recovery (post api), should exists, but doesn't");
            }
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to fetch index version after copying it over", (Throwable)e);
        }
        recoveryStatus.index().updateVersion(version);
        recoveryStatus.index().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
        try {
            int numberOfFiles = 0;
            long totalSizeInBytes = 0L;
            for (String name : this.indexShard.store().directory().listAll()) {
                ++numberOfFiles;
                totalSizeInBytes += this.indexShard.store().directory().fileLength(name);
            }
            recoveryStatus.index().files(numberOfFiles, totalSizeInBytes, numberOfFiles, totalSizeInBytes);
        }
        catch (Exception e) {
            // empty catch block
        }
        recoveryStatus.start().startTime(System.currentTimeMillis());
        recoveryStatus.updateStage(RecoveryStatus.Stage.START);
        if (translogId == -1L) {
            this.indexShard.start("post recovery from gateway, no translog");
            recoveryStatus.start().time(System.currentTimeMillis() - recoveryStatus.start().startTime());
            recoveryStatus.start().checkIndexTime(this.indexShard.checkIndexTook());
            return;
        }
        FsTranslog translog = (FsTranslog)this.indexShard.translog();
        String translogName = "translog-" + translogId;
        String recoverTranslogName = translogName + ".recovering";
        File recoveringTranslogFile = null;
        block12: for (File translogLocation : translog.locations()) {
            File tmpRecoveringFile = new File(translogLocation, recoverTranslogName);
            if (!tmpRecoveringFile.exists()) {
                File tmpTranslogFile = new File(translogLocation, translogName);
                if (!tmpTranslogFile.exists()) continue;
                for (int i = 0; i < 3; ++i) {
                    if (!tmpTranslogFile.renameTo(tmpRecoveringFile)) continue;
                    recoveringTranslogFile = tmpRecoveringFile;
                    continue block12;
                }
                continue;
            }
            recoveringTranslogFile = tmpRecoveringFile;
            break;
        }
        if (recoveringTranslogFile == null || !recoveringTranslogFile.exists()) {
            this.indexShard.start("post recovery from gateway, no translog");
            recoveryStatus.start().time(System.currentTimeMillis() - recoveryStatus.start().startTime());
            recoveryStatus.start().checkIndexTime(this.indexShard.checkIndexTook());
            return;
        }
        this.indexShard.performRecoveryPrepareForTranslog();
        recoveryStatus.start().time(System.currentTimeMillis() - recoveryStatus.start().startTime());
        recoveryStatus.start().checkIndexTime(this.indexShard.checkIndexTook());
        recoveryStatus.translog().startTime(System.currentTimeMillis());
        recoveryStatus.updateStage(RecoveryStatus.Stage.TRANSLOG);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(recoveringTranslogFile);
            InputStreamStreamInput si = new InputStreamStreamInput(fs);
            while (true) {
                Translog.Operation operation;
                try {
                    int opSize = si.readInt();
                    operation = TranslogStreams.readTranslogOperation(si);
                }
                catch (EOFException e) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
                recoveryStatus.translog().addTranslogOperations(1);
                this.indexShard.performRecoveryOperation(operation);
            }
        }
        catch (Throwable e) {
            try {
                this.indexShard.translog().close(true);
                throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover shard", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fs);
                throw throwable;
            }
        }
        Closeables.closeQuietly(fs);
        this.indexShard.performRecoveryFinalization(true);
        recoveringTranslogFile.delete();
        recoveryStatus.translog().time(System.currentTimeMillis() - recoveryStatus.translog().startTime());
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    public SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) {
        return null;
    }

    @Override
    public SnapshotStatus lastSnapshotStatus() {
        return null;
    }

    @Override
    public SnapshotStatus currentSnapshotStatus() {
        return null;
    }

    @Override
    public boolean requiresSnapshot() {
        return false;
    }

    @Override
    public boolean requiresSnapshotScheduling() {
        return false;
    }

    @Override
    public void close(boolean delete) {
        if (this.flushScheduler != null) {
            this.flushScheduler.cancel(false);
        }
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        return NO_SNAPSHOT_LOCK;
    }

    class Sync
    implements Runnable {
        Sync() {
        }

        @Override
        public void run() {
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.STARTED && LocalIndexShardGateway.this.indexShard.translog().syncNeeded()) {
                LocalIndexShardGateway.this.threadPool.executor("snapshot").execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                LocalIndexShardGateway.this.indexShard.translog().sync();
                            }
                            catch (Exception e) {
                                if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.STARTED) break block3;
                                LocalIndexShardGateway.this.logger.warn("failed to sync translog", e, new Object[0]);
                            }
                        }
                        if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.CLOSED) {
                            LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", Sync.this);
                        }
                    }
                });
            } else {
                LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", this);
            }
        }
    }
}

