/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.FastByteArrayInputStream;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.lucene.store.ThreadSafeInputStreamIndexInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.gateway.CommitPoint;
import org.elasticsearch.index.gateway.CommitPoints;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewaySnapshotFailedException;
import org.elasticsearch.index.gateway.RecoveryStatus;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.gateway.blobstore.BlobStoreIndexGateway;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class BlobStoreIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    protected final ThreadPool threadPool;
    protected final InternalIndexShard indexShard;
    protected final Store store;
    protected final ByteSizeValue chunkSize;
    protected final BlobStore blobStore;
    protected final BlobPath shardPath;
    protected final ImmutableBlobContainer blobContainer;
    private volatile RecoveryStatus recoveryStatus;
    private volatile SnapshotStatus lastSnapshotStatus;
    private volatile SnapshotStatus currentSnapshotStatus;

    protected BlobStoreIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexGateway indexGateway, IndexShard indexShard, Store store) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexShard = (InternalIndexShard)indexShard;
        this.store = store;
        BlobStoreIndexGateway blobStoreIndexGateway = (BlobStoreIndexGateway)indexGateway;
        this.chunkSize = blobStoreIndexGateway.chunkSize();
        this.blobStore = blobStoreIndexGateway.blobStore();
        this.shardPath = blobStoreIndexGateway.shardPath(shardId.id());
        this.blobContainer = this.blobStore.immutableBlobContainer(this.shardPath);
        this.recoveryStatus = new RecoveryStatus();
    }

    @Override
    public RecoveryStatus recoveryStatus() {
        return this.recoveryStatus;
    }

    public String toString() {
        return this.type() + "://" + this.blobStore + "/" + this.shardPath;
    }

    @Override
    public boolean requiresSnapshot() {
        return true;
    }

    @Override
    public boolean requiresSnapshotScheduling() {
        return true;
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        return NO_SNAPSHOT_LOCK;
    }

    @Override
    public void close(boolean delete) throws ElasticSearchException {
        if (delete) {
            this.blobStore.delete(this.shardPath);
        }
    }

    @Override
    public SnapshotStatus lastSnapshotStatus() {
        return this.lastSnapshotStatus;
    }

    @Override
    public SnapshotStatus currentSnapshotStatus() {
        SnapshotStatus snapshotStatus = this.currentSnapshotStatus;
        if (snapshotStatus == null) {
            return snapshotStatus;
        }
        if (snapshotStatus.stage() != SnapshotStatus.Stage.DONE || snapshotStatus.stage() != SnapshotStatus.Stage.FAILURE) {
            snapshotStatus.time(System.currentTimeMillis() - snapshotStatus.startTime());
        }
        return snapshotStatus;
    }

    @Override
    public SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) throws IndexShardGatewaySnapshotFailedException {
        this.currentSnapshotStatus = new SnapshotStatus();
        this.currentSnapshotStatus.startTime(System.currentTimeMillis());
        try {
            this.doSnapshot(snapshot);
            this.currentSnapshotStatus.time(System.currentTimeMillis() - this.currentSnapshotStatus.startTime());
            this.currentSnapshotStatus.updateStage(SnapshotStatus.Stage.DONE);
        }
        catch (Exception e) {
            this.currentSnapshotStatus.time(System.currentTimeMillis() - this.currentSnapshotStatus.startTime());
            this.currentSnapshotStatus.updateStage(SnapshotStatus.Stage.FAILURE);
            this.currentSnapshotStatus.failed(e);
            if (e instanceof IndexShardGatewaySnapshotFailedException) {
                throw (IndexShardGatewaySnapshotFailedException)e;
            }
            throw new IndexShardGatewaySnapshotFailedException(this.shardId, e.getMessage(), (Throwable)e);
        }
        finally {
            this.lastSnapshotStatus = this.currentSnapshotStatus;
            this.currentSnapshotStatus = null;
        }
        return this.lastSnapshotStatus;
    }

    private void doSnapshot(IndexShardGateway.Snapshot snapshot) throws IndexShardGatewaySnapshotFailedException {
        ImmutableMap<String, BlobMetaData> blobs;
        try {
            blobs = this.blobContainer.listBlobs();
        }
        catch (IOException e) {
            throw new IndexShardGatewaySnapshotFailedException(this.shardId, "failed to list blobs", (Throwable)e);
        }
        long generation = this.findLatestFileNameGeneration(blobs);
        CommitPoints commitPoints = this.buildCommitPoints(blobs);
        this.currentSnapshotStatus.index().startTime(System.currentTimeMillis());
        this.currentSnapshotStatus.updateStage(SnapshotStatus.Stage.INDEX);
        SnapshotIndexCommit snapshotIndexCommit = snapshot.indexCommit();
        Translog.Snapshot translogSnapshot = snapshot.translogSnapshot();
        CountDownLatch indexLatch = new CountDownLatch(snapshotIndexCommit.getFiles().length);
        CopyOnWriteArrayList<Throwable> failures = new CopyOnWriteArrayList<Throwable>();
        ArrayList<CommitPoint.FileInfo> indexCommitPointFiles = Lists.newArrayList();
        int indexNumberOfFiles = 0;
        long indexTotalFilesSize = 0L;
        for (String fileName : snapshotIndexCommit.getFiles()) {
            CommitPoint.FileInfo fileInfo;
            StoreFileMetaData md;
            try {
                md = this.store.metaData(fileName);
            }
            catch (IOException e) {
                throw new IndexShardGatewaySnapshotFailedException(this.shardId, "Failed to get store file metadata", (Throwable)e);
            }
            boolean snapshotRequired = false;
            if (snapshot.indexChanged() && fileName.equals(snapshotIndexCommit.getSegmentsFileName())) {
                snapshotRequired = true;
            }
            if ((fileInfo = commitPoints.findPhysicalIndexFile(fileName)) == null || !fileInfo.isSame(md) || !this.commitPointFileExistsInBlobs(fileInfo, blobs)) {
                snapshotRequired = true;
            }
            if (snapshotRequired) {
                ++indexNumberOfFiles;
                indexTotalFilesSize += md.length();
                try {
                    CommitPoint.FileInfo snapshotFileInfo = new CommitPoint.FileInfo(this.fileNameFromGeneration(++generation), fileName, md.length(), md.checksum());
                    indexCommitPointFiles.add(snapshotFileInfo);
                    this.snapshotFile(snapshotIndexCommit.getDirectory(), snapshotFileInfo, indexLatch, failures);
                }
                catch (IOException e) {
                    failures.add(e);
                    indexLatch.countDown();
                }
                continue;
            }
            indexCommitPointFiles.add(fileInfo);
            indexLatch.countDown();
        }
        this.currentSnapshotStatus.index().files(indexNumberOfFiles, indexTotalFilesSize);
        try {
            indexLatch.await();
        }
        catch (InterruptedException e) {
            failures.add(e);
        }
        if (!failures.isEmpty()) {
            throw new IndexShardGatewaySnapshotFailedException(this.shardId(), "Failed to perform snapshot (index files)", (Throwable)failures.get(failures.size() - 1));
        }
        this.currentSnapshotStatus.index().time(System.currentTimeMillis() - this.currentSnapshotStatus.index().startTime());
        this.currentSnapshotStatus.updateStage(SnapshotStatus.Stage.TRANSLOG);
        this.currentSnapshotStatus.translog().startTime(System.currentTimeMillis());
        ArrayList<CommitPoint.FileInfo> translogCommitPointFiles = Lists.newArrayList();
        int expectedNumberOfOperations = 0;
        boolean snapshotRequired = false;
        if (snapshot.newTranslogCreated()) {
            if (translogSnapshot.lengthInBytes() > 0L) {
                snapshotRequired = true;
                expectedNumberOfOperations = translogSnapshot.estimatedTotalOperations();
            }
        } else if (!commitPoints.commits().isEmpty()) {
            CommitPoint commitPoint = (CommitPoint)commitPoints.commits().get(0);
            boolean allTranslogFilesExists = true;
            for (CommitPoint.FileInfo fileInfo : commitPoint.translogFiles()) {
                if (this.commitPointFileExistsInBlobs(fileInfo, blobs)) continue;
                allTranslogFilesExists = false;
                break;
            }
            if (allTranslogFilesExists) {
                translogCommitPointFiles.addAll(commitPoint.translogFiles());
                if (snapshot.sameTranslogNewOperations()) {
                    translogSnapshot.seekForward(snapshot.lastTranslogLength());
                    if (translogSnapshot.lengthInBytes() > 0L) {
                        snapshotRequired = true;
                        expectedNumberOfOperations = translogSnapshot.estimatedTotalOperations() - snapshot.lastTotalTranslogOperations();
                    }
                }
            } else if (translogSnapshot.lengthInBytes() > 0L) {
                expectedNumberOfOperations = translogSnapshot.estimatedTotalOperations();
                snapshotRequired = true;
            }
        } else if (translogSnapshot.lengthInBytes() > 0L) {
            expectedNumberOfOperations = translogSnapshot.estimatedTotalOperations();
            snapshotRequired = true;
        }
        this.currentSnapshotStatus.translog().expectedNumberOfOperations(expectedNumberOfOperations);
        if (snapshotRequired) {
            CommitPoint.FileInfo addedTranslogFileInfo = new CommitPoint.FileInfo(this.fileNameFromGeneration(++generation), "translog-" + translogSnapshot.translogId(), translogSnapshot.lengthInBytes(), null);
            translogCommitPointFiles.add(addedTranslogFileInfo);
            try {
                this.snapshotTranslog(translogSnapshot, addedTranslogFileInfo);
            }
            catch (Exception e) {
                throw new IndexShardGatewaySnapshotFailedException(this.shardId, "Failed to snapshot translog", (Throwable)e);
            }
        }
        this.currentSnapshotStatus.translog().time(System.currentTimeMillis() - this.currentSnapshotStatus.translog().startTime());
        this.currentSnapshotStatus.updateStage(SnapshotStatus.Stage.FINALIZE);
        long version = 0L;
        if (!commitPoints.commits().isEmpty()) {
            version = ((CommitPoint)commitPoints.commits().iterator().next()).version() + 1L;
        }
        String commitPointName = "commit-" + Long.toString(version, 36);
        CommitPoint commitPoint = new CommitPoint(version, commitPointName, CommitPoint.Type.GENERATED, indexCommitPointFiles, translogCommitPointFiles);
        try {
            byte[] commitPointData = CommitPoints.toXContent(commitPoint);
            this.blobContainer.writeBlob(commitPointName, new FastByteArrayInputStream(commitPointData), commitPointData.length);
        }
        catch (Exception e) {
            throw new IndexShardGatewaySnapshotFailedException(this.shardId, "Failed to write commit point", (Throwable)e);
        }
        ArrayList<CommitPoint> newCommitPointsList = Lists.newArrayList();
        newCommitPointsList.add(commitPoint);
        for (CommitPoint point : commitPoints) {
            if (point.type() != CommitPoint.Type.SAVED) continue;
            newCommitPointsList.add(point);
        }
        CommitPoints newCommitPoints = new CommitPoints(newCommitPointsList);
        for (String blobName : blobs.keySet()) {
            long checkedVersion;
            if (!blobName.startsWith("commit-") || newCommitPoints.hasVersion(checkedVersion = Long.parseLong(blobName.substring("commit-".length()), 36))) continue;
            try {
                this.blobContainer.deleteBlob(blobName);
            }
            catch (IOException e) {}
        }
        for (String blobName : blobs.keySet()) {
            String name = blobName;
            if (!name.startsWith("__")) continue;
            if (blobName.contains(".part")) {
                name = blobName.substring(0, blobName.indexOf(".part"));
            }
            if (newCommitPoints.findNameFile(name) != null) continue;
            try {
                this.blobContainer.deleteBlob(blobName);
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void recover(boolean indexShouldExists, RecoveryStatus recoveryStatus) throws IndexShardGatewayRecoveryException {
        ImmutableMap<String, BlobMetaData> blobs;
        this.recoveryStatus = recoveryStatus;
        try {
            blobs = this.blobContainer.listBlobs();
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId, "Failed to list content of gateway", (Throwable)e);
        }
        ArrayList<CommitPoint> commitPointsList = Lists.newArrayList();
        boolean atLeastOneCommitPointExists = false;
        for (String name : blobs.keySet()) {
            if (!name.startsWith("commit-")) continue;
            atLeastOneCommitPointExists = true;
            try {
                commitPointsList.add(CommitPoints.fromXContent(this.blobContainer.readBlobFully(name)));
            }
            catch (Exception e) {
                this.logger.warn("failed to read commit point [{}]", e, name);
            }
        }
        if (atLeastOneCommitPointExists && commitPointsList.isEmpty()) {
            throw new IndexShardGatewayRecoveryException(this.shardId, "Commit points exists but none could be loaded", null);
        }
        CommitPoints commitPoints = new CommitPoints(commitPointsList);
        if (commitPoints.commits().isEmpty()) {
            try {
                this.indexShard.store().deleteContent();
            }
            catch (IOException e) {
                this.logger.warn("failed to clean store before starting shard", e, new Object[0]);
            }
            recoveryStatus.index().startTime(System.currentTimeMillis());
            recoveryStatus.index().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
            return;
        }
        for (CommitPoint commitPoint : commitPoints) {
            if (!this.commitPointExistsInBlobs(commitPoint, blobs)) {
                this.logger.warn("listed commit_point [{}]/[{}], but not all files exists, ignoring", commitPoint.name(), commitPoint.version());
                continue;
            }
            try {
                recoveryStatus.index().startTime(System.currentTimeMillis());
                this.recoverIndex(commitPoint, blobs);
                recoveryStatus.index().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
                this.recoverTranslog(commitPoint, blobs);
                return;
            }
            catch (Exception e) {
                throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover commit_point [" + commitPoint.name() + "]/[" + commitPoint.version() + "]", (Throwable)e);
            }
        }
        throw new IndexShardGatewayRecoveryException(this.shardId, "No commit point data is available in gateway", null);
    }

    private void recoverTranslog(CommitPoint commitPoint, ImmutableMap<String, BlobMetaData> blobs) throws IndexShardGatewayRecoveryException {
        if (commitPoint.translogFiles().isEmpty()) {
            this.recoveryStatus.start().startTime(System.currentTimeMillis());
            this.recoveryStatus.updateStage(RecoveryStatus.Stage.START);
            this.indexShard.start("post recovery from gateway, no translog");
            this.recoveryStatus.start().time(System.currentTimeMillis() - this.recoveryStatus.start().startTime());
            this.recoveryStatus.start().checkIndexTime(this.indexShard.checkIndexTook());
            return;
        }
        try {
            this.recoveryStatus.start().startTime(System.currentTimeMillis());
            this.recoveryStatus.updateStage(RecoveryStatus.Stage.START);
            this.indexShard.performRecoveryPrepareForTranslog();
            this.recoveryStatus.start().time(System.currentTimeMillis() - this.recoveryStatus.start().startTime());
            this.recoveryStatus.start().checkIndexTime(this.indexShard.checkIndexTook());
            this.recoveryStatus.updateStage(RecoveryStatus.Stage.TRANSLOG);
            this.recoveryStatus.translog().startTime(System.currentTimeMillis());
            final AtomicReference failure = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            final Iterator transIt = commitPoint.translogFiles().iterator();
            this.blobContainer.readBlob(((CommitPoint.FileInfo)transIt.next()).name(), new BlobContainer.ReadBlobListener(){
                FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
                boolean ignore = false;

                @Override
                public synchronized void onPartial(byte[] data, int offset, int size) throws IOException {
                    int position;
                    if (this.ignore) {
                        return;
                    }
                    this.bos.write(data, offset, size);
                    if (this.bos.size() < 4) {
                        return;
                    }
                    BytesStreamInput si = new BytesStreamInput(this.bos.underlyingBytes(), 0, this.bos.size(), false);
                    try {
                        while ((position = si.position()) + 4 <= this.bos.size()) {
                            int opSize = si.readInt();
                            int curPos = si.position();
                            if (si.position() + opSize <= this.bos.size()) {
                                Translog.Operation operation = TranslogStreams.readTranslogOperation(si);
                                if (si.position() - curPos != opSize) {
                                    BlobStoreIndexShardGateway.this.logger.warn("mismatch in size, expected [{}], got [{}]", opSize, si.position() - curPos);
                                }
                                BlobStoreIndexShardGateway.this.recoveryStatus.translog().addTranslogOperations(1);
                                BlobStoreIndexShardGateway.this.indexShard.performRecoveryOperation(operation);
                                if (si.position() < this.bos.size()) continue;
                                position = si.position();
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        BlobStoreIndexShardGateway.this.logger.warn("failed to retrieve translog after [{}] operations, ignoring the rest, considered corrupted", e, BlobStoreIndexShardGateway.this.recoveryStatus.translog().currentTranslogOperations());
                        this.ignore = true;
                        latch.countDown();
                        return;
                    }
                    FastByteArrayOutputStream newBos = new FastByteArrayOutputStream();
                    int leftOver = this.bos.size() - position;
                    if (leftOver > 0) {
                        newBos.write(this.bos.underlyingBytes(), position, leftOver);
                    }
                    this.bos = newBos;
                }

                @Override
                public synchronized void onCompleted() {
                    if (this.ignore) {
                        return;
                    }
                    if (!transIt.hasNext()) {
                        latch.countDown();
                        return;
                    }
                    BlobStoreIndexShardGateway.this.blobContainer.readBlob(((CommitPoint.FileInfo)transIt.next()).name(), this);
                }

                @Override
                public void onFailure(Throwable t) {
                    failure.set(t);
                    latch.countDown();
                }
            });
            latch.await();
            if (failure.get() != null) {
                throw (Throwable)failure.get();
            }
            this.indexShard.performRecoveryFinalization(true);
            this.recoveryStatus.translog().time(System.currentTimeMillis() - this.recoveryStatus.translog().startTime());
        }
        catch (Throwable e) {
            throw new IndexShardGatewayRecoveryException(this.shardId, "Failed to recover translog", e);
        }
    }

    private void recoverIndex(CommitPoint commitPoint, ImmutableMap<String, BlobMetaData> blobs) throws Exception {
        this.recoveryStatus.updateStage(RecoveryStatus.Stage.INDEX);
        int numberOfFiles = 0;
        long totalSize = 0L;
        int numberOfReusedFiles = 0;
        long reusedTotalSize = 0L;
        ArrayList<CommitPoint.FileInfo> filesToRecover = Lists.newArrayList();
        for (CommitPoint.FileInfo fileInfo : commitPoint.indexFiles()) {
            String fileName = fileInfo.physicalName();
            StoreFileMetaData md = null;
            try {
                md = this.store.metaData(fileName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!fileName.startsWith("segments") && md != null && fileInfo.isSame(md)) {
                ++numberOfFiles;
                totalSize += md.length();
                ++numberOfReusedFiles;
                reusedTotalSize += md.length();
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("not_recovering [{}], exists in local store and is same", fileInfo.physicalName());
                continue;
            }
            if (this.logger.isTraceEnabled()) {
                if (md == null) {
                    this.logger.trace("recovering [{}], does not exists in local store", fileInfo.physicalName());
                } else {
                    this.logger.trace("recovering [{}], exists in local store but is different", fileInfo.physicalName());
                }
            }
            ++numberOfFiles;
            totalSize += fileInfo.length();
            filesToRecover.add(fileInfo);
        }
        this.recoveryStatus.index().files(numberOfFiles, totalSize, numberOfReusedFiles, reusedTotalSize);
        if (filesToRecover.isEmpty()) {
            this.logger.trace("no files to recover, all exists within the local store", new Object[0]);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("recovering_files [{}] with total_size [{}], reusing_files [{}] with reused_size [{}]", numberOfFiles, new ByteSizeValue(totalSize), numberOfReusedFiles, new ByteSizeValue(reusedTotalSize));
        }
        CountDownLatch latch = new CountDownLatch(filesToRecover.size());
        CopyOnWriteArrayList<Throwable> failures = new CopyOnWriteArrayList<Throwable>();
        for (CommitPoint.FileInfo fileToRecover : filesToRecover) {
            this.recoverFile(fileToRecover, blobs, latch, failures);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId, "Interrupted while recovering index", (Throwable)e);
        }
        if (!failures.isEmpty()) {
            throw new IndexShardGatewayRecoveryException(this.shardId, "Failed to recover index", failures.get(0));
        }
        long version = -1L;
        try {
            if (IndexReader.indexExists((Directory)this.store.directory())) {
                version = IndexReader.getCurrentVersion((Directory)this.store.directory());
            }
        }
        catch (IOException e) {
            throw new IndexShardGatewayRecoveryException(this.shardId(), "Failed to fetch index version after copying it over", (Throwable)e);
        }
        this.recoveryStatus.index().updateVersion(version);
        try {
            for (String storeFile : this.store.directory().listAll()) {
                if (commitPoint.containPhysicalIndexFile(storeFile)) continue;
                try {
                    this.store.directory().deleteFile(storeFile);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void recoverFile(final CommitPoint.FileInfo fileInfo, final ImmutableMap<String, BlobMetaData> blobs, final CountDownLatch latch, final List<Throwable> failures) {
        IndexOutput indexOutput;
        try {
            indexOutput = this.store.createOutputRaw(fileInfo.physicalName());
        }
        catch (IOException e) {
            failures.add(e);
            latch.countDown();
            return;
        }
        String firstFileToRecover = fileInfo.name();
        if (!blobs.containsKey(fileInfo.name())) {
            firstFileToRecover = fileInfo.name() + ".part0";
        }
        if (!blobs.containsKey(firstFileToRecover)) {
            this.logger.warn("no file [{}]/[{}] to recover, ignoring it", fileInfo.name(), fileInfo.physicalName());
            latch.countDown();
            return;
        }
        final AtomicInteger partIndex = new AtomicInteger();
        this.blobContainer.readBlob(firstFileToRecover, new BlobContainer.ReadBlobListener(){

            @Override
            public synchronized void onPartial(byte[] data, int offset, int size) throws IOException {
                BlobStoreIndexShardGateway.this.recoveryStatus.index().addCurrentFilesSize(size);
                indexOutput.writeBytes(data, offset, size);
            }

            @Override
            public synchronized void onCompleted() {
                int part = partIndex.incrementAndGet();
                String partName = fileInfo.name() + ".part" + part;
                if (blobs.containsKey(partName)) {
                    BlobStoreIndexShardGateway.this.blobContainer.readBlob(partName, this);
                    return;
                }
                try {
                    indexOutput.close();
                    if (fileInfo.checksum() != null) {
                        BlobStoreIndexShardGateway.this.store.writeChecksum(fileInfo.physicalName(), fileInfo.checksum());
                    }
                    BlobStoreIndexShardGateway.this.store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                }
                catch (IOException e) {
                    this.onFailure(e);
                    return;
                }
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failures.add(t);
                latch.countDown();
            }
        });
    }

    private void snapshotTranslog(Translog.Snapshot snapshot, CommitPoint.FileInfo fileInfo) throws IOException {
        this.blobContainer.writeBlob(fileInfo.name(), snapshot.stream(), snapshot.lengthInBytes());
    }

    private void snapshotFile(Directory dir, CommitPoint.FileInfo fileInfo, final CountDownLatch latch, final List<Throwable> failures) throws IOException {
        long chunkBytes = Long.MAX_VALUE;
        if (this.chunkSize != null) {
            chunkBytes = this.chunkSize.bytes();
        }
        long totalLength = fileInfo.length();
        long numberOfChunks = totalLength / chunkBytes;
        if (totalLength % chunkBytes > 0L) {
            ++numberOfChunks;
        }
        if (numberOfChunks == 0L) {
            ++numberOfChunks;
        }
        long fNumberOfChunks = numberOfChunks;
        final AtomicLong counter = new AtomicLong(numberOfChunks);
        for (long i = 0L; i < fNumberOfChunks; ++i) {
            long partNumber = i;
            IndexInput indexInput = null;
            try {
                indexInput = this.indexShard.store().openInputRaw(fileInfo.physicalName());
                indexInput.seek(partNumber * chunkBytes);
                ThreadSafeInputStreamIndexInput is = new ThreadSafeInputStreamIndexInput(indexInput, chunkBytes);
                String blobName = fileInfo.name();
                if (fNumberOfChunks > 1L) {
                    blobName = blobName + ".part" + partNumber;
                }
                final IndexInput fIndexInput = indexInput;
                this.blobContainer.writeBlob(blobName, is, is.actualSizeToRead(), new ImmutableBlobContainer.WriterListener(){

                    @Override
                    public void onCompleted() {
                        try {
                            fIndexInput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (counter.decrementAndGet() == 0L) {
                            latch.countDown();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        try {
                            fIndexInput.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        failures.add(t);
                        if (counter.decrementAndGet() == 0L) {
                            latch.countDown();
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                if (indexInput != null) {
                    try {
                        indexInput.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                failures.add(e);
                latch.countDown();
            }
        }
    }

    private boolean commitPointExistsInBlobs(CommitPoint commitPoint, ImmutableMap<String, BlobMetaData> blobs) {
        for (CommitPoint.FileInfo fileInfo : Iterables.concat(commitPoint.indexFiles(), commitPoint.translogFiles())) {
            if (this.commitPointFileExistsInBlobs(fileInfo, blobs)) continue;
            return false;
        }
        return true;
    }

    private boolean commitPointFileExistsInBlobs(CommitPoint.FileInfo fileInfo, ImmutableMap<String, BlobMetaData> blobs) {
        BlobMetaData blobMetaData = blobs.get(fileInfo.name());
        if (blobMetaData != null) {
            if (blobMetaData.length() != fileInfo.length()) {
                return false;
            }
        } else if (blobs.containsKey(fileInfo.name() + ".part0")) {
            int part = 0;
            long totalSize = 0L;
            while ((blobMetaData = blobs.get(fileInfo.name() + ".part" + part++)) != null) {
                totalSize += blobMetaData.length();
            }
            if (totalSize != fileInfo.length()) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private CommitPoints buildCommitPoints(ImmutableMap<String, BlobMetaData> blobs) {
        ArrayList<CommitPoint> commitPoints = Lists.newArrayList();
        for (String name : blobs.keySet()) {
            if (!name.startsWith("commit-")) continue;
            try {
                commitPoints.add(CommitPoints.fromXContent(this.blobContainer.readBlobFully(name)));
            }
            catch (Exception e) {
                this.logger.warn("failed to read commit point [{}]", e, name);
            }
        }
        return new CommitPoints(commitPoints);
    }

    private String fileNameFromGeneration(long generation) {
        return "__" + Long.toString(generation, 36);
    }

    private long findLatestFileNameGeneration(ImmutableMap<String, BlobMetaData> blobs) {
        long generation = -1L;
        for (String name : blobs.keySet()) {
            if (!name.startsWith("__")) continue;
            if (name.contains(".part")) {
                name = name.substring(0, name.indexOf(".part"));
            }
            try {
                long currentGen = Long.parseLong(name.substring(2), 36);
                if (currentGen <= generation) continue;
                generation = currentGen;
            }
            catch (NumberFormatException e) {
                this.logger.warn("file [{}] does not conform to the '__' schema", new Object[0]);
            }
        }
        return generation;
    }
}

