/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.weighted;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.cache.filter.IndicesFilterCache;

public class WeightedFilterCache
extends AbstractIndexComponent
implements FilterCache,
SegmentReader.CoreClosedListener,
RemovalListener<FilterCacheKey, DocSet> {
    final IndicesFilterCache indicesFilterCache;
    final ConcurrentMap<Object, Boolean> seenReaders = ConcurrentCollections.newConcurrentMap();
    final CounterMetric seenReadersCount = new CounterMetric();
    final CounterMetric evictionsMetric = new CounterMetric();
    final MeanMetric totalMetric = new MeanMetric();

    @Inject
    public WeightedFilterCache(Index index, @IndexSettings Settings indexSettings, IndicesFilterCache indicesFilterCache) {
        super(index, indexSettings);
        this.indicesFilterCache = indicesFilterCache;
        indicesFilterCache.addRemovalListener(index.name(), this);
    }

    @Override
    public String type() {
        return "weighted";
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear("close");
        this.indicesFilterCache.removeRemovalListener(this.index.name());
    }

    @Override
    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", reason);
        for (Object readerKey : this.seenReaders.keySet()) {
            Boolean removed = (Boolean)this.seenReaders.remove(readerKey);
            if (removed == null) {
                return;
            }
            this.seenReadersCount.dec();
            for (FilterCacheKey key : this.indicesFilterCache.cache().asMap().keySet()) {
                if (key.readerKey() != readerKey) continue;
                this.indicesFilterCache.cache().invalidate(key);
            }
        }
    }

    public void onClose(SegmentReader owner) {
        this.clear((IndexReader)owner);
    }

    @Override
    public void clear(IndexReader reader) {
        Boolean removed = (Boolean)this.seenReaders.remove(reader.getCoreCacheKey());
        if (removed == null) {
            return;
        }
        this.seenReadersCount.dec();
        Cache<FilterCacheKey, DocSet> cache = this.indicesFilterCache.cache();
        for (FilterCacheKey key : cache.asMap().keySet()) {
            if (key.readerKey() != reader.getCoreCacheKey()) continue;
            cache.invalidate(key);
        }
    }

    @Override
    public FilterCache.EntriesStats entriesStats() {
        long seenReadersCount = this.seenReadersCount.count();
        return new FilterCache.EntriesStats(this.totalMetric.sum(), seenReadersCount == 0L ? 0L : this.totalMetric.count() / seenReadersCount);
    }

    @Override
    public long evictions() {
        return this.evictionsMetric.count();
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (filterToCache instanceof NoCacheFilter) {
            return filterToCache;
        }
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public boolean isCached(Filter filter) {
        return filter instanceof FilterCacheFilterWrapper;
    }

    @Override
    public void onRemoval(RemovalNotification<FilterCacheKey, DocSet> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictionsMetric.inc();
        }
        if (removalNotification.getValue() != null) {
            this.totalMetric.dec(removalNotification.getValue().sizeInBytes());
        }
    }

    public static class FilterCacheKey {
        private final String index;
        private final Object readerKey;
        private final Object filterKey;

        public FilterCacheKey(String index, Object readerKey, Object filterKey) {
            this.index = index;
            this.readerKey = readerKey;
            this.filterKey = filterKey;
        }

        public String index() {
            return this.index;
        }

        public Object readerKey() {
            return this.readerKey;
        }

        public Object filterKey() {
            return this.filterKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FilterCacheKey that = (FilterCacheKey)o;
            return this.readerKey == that.readerKey && this.filterKey.equals(that.filterKey);
        }

        public int hashCode() {
            return this.readerKey.hashCode() + 31 * this.filterKey.hashCode();
        }
    }

    public static class FilterCacheValueWeigher
    implements Weigher<FilterCacheKey, DocSet> {
        @Override
        public int weigh(FilterCacheKey key, DocSet value) {
            int weight = (int)Math.min(value.sizeInBytes(), Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }

    static class FilterCacheFilterWrapper
    extends Filter {
        private final Filter filter;
        private final WeightedFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, WeightedFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            Object filterKey = this.filter;
            if (this.filter instanceof CacheKeyFilter) {
                filterKey = ((CacheKeyFilter)this.filter).cacheKey();
            }
            FilterCacheKey cacheKey = new FilterCacheKey(this.cache.index().name(), reader.getCoreCacheKey(), filterKey);
            Cache<FilterCacheKey, DocSet> innerCache = this.cache.indicesFilterCache.cache();
            DocSet cacheValue = innerCache.getIfPresent(cacheKey);
            if (cacheValue == null) {
                Boolean previous;
                if (!this.cache.seenReaders.containsKey(reader.getCoreCacheKey()) && (previous = this.cache.seenReaders.putIfAbsent(reader.getCoreCacheKey(), Boolean.TRUE)) == null && reader instanceof SegmentReader) {
                    ((SegmentReader)reader).addCoreClosedListener((SegmentReader.CoreClosedListener)this.cache);
                    this.cache.seenReadersCount.inc();
                }
                cacheValue = DocSets.cacheable(reader, this.filter.getDocIdSet(reader));
                this.cache.totalMetric.inc(cacheValue.sizeInBytes());
                innerCache.put(cacheKey, cacheValue);
            }
            return cacheValue == DocSet.EMPTY_DOC_SET ? null : cacheValue;
        }

        public String toString() {
            return "cache(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }
}

