/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.field.data.support;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractConcurrentMapFieldDataCache
extends AbstractIndexComponent
implements FieldDataCache,
SegmentReader.CoreClosedListener {
    private final ConcurrentMap<Object, Cache<String, FieldData>> cache;
    private final Object creationMutex = new Object();

    protected AbstractConcurrentMapFieldDataCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.cache = ConcurrentCollections.newConcurrentMap();
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear("close");
    }

    @Override
    public void clear(String reason, String fieldName) {
        this.logger.debug("clearing field [{}] cache, reason [{}]", fieldName, reason);
        for (Map.Entry entry : this.cache.entrySet()) {
            ((Cache)entry.getValue()).invalidate(fieldName);
        }
    }

    @Override
    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", reason);
        this.cache.clear();
    }

    public void onClose(SegmentReader owner) {
        this.clear((IndexReader)owner);
    }

    @Override
    public void clear(IndexReader reader) {
        this.cache.remove(reader.getCoreCacheKey());
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (Cache map : this.cache.values()) {
            for (FieldData fieldData : map.asMap().values()) {
                sizeInBytes += fieldData.sizeInBytes();
            }
        }
        return sizeInBytes;
    }

    @Override
    public long sizeInBytes(String fieldName) {
        long sizeInBytes = 0L;
        for (Cache map : this.cache.values()) {
            FieldData fieldData = (FieldData)map.getIfPresent(fieldName);
            if (fieldData == null) continue;
            sizeInBytes += fieldData.sizeInBytes();
        }
        return sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldData cache(FieldDataType type, IndexReader reader, String fieldName) throws IOException {
        FieldData fieldData;
        Cache<String, FieldData> fieldDataCache = (Cache<String, FieldData>)this.cache.get(reader.getCoreCacheKey());
        if (fieldDataCache == null) {
            Object object = this.creationMutex;
            synchronized (object) {
                fieldDataCache = (Cache)this.cache.get(reader.getCoreCacheKey());
                if (fieldDataCache == null) {
                    fieldDataCache = this.buildFieldDataMap();
                    if (reader instanceof SegmentReader) {
                        ((SegmentReader)reader).addCoreClosedListener((SegmentReader.CoreClosedListener)this);
                    }
                    this.cache.put(reader.getCoreCacheKey(), fieldDataCache);
                }
            }
        }
        if ((fieldData = (FieldData)fieldDataCache.getIfPresent(fieldName)) == null) {
            Cache<String, FieldData> cache = fieldDataCache;
            synchronized (cache) {
                fieldData = (FieldData)fieldDataCache.getIfPresent(fieldName);
                if (fieldData == null) {
                    try {
                        long time = System.nanoTime();
                        fieldData = FieldData.load(type, reader, fieldName);
                        fieldDataCache.put(fieldName, fieldData);
                        long took = System.nanoTime() - time;
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("loaded field [{}] for reader [{}], took [{}], took_millis [{}]", fieldName, reader, TimeValue.timeValueNanos(took), took / 1000L);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        this.logger.warn("loading field [" + fieldName + "] caused out of memory failure", e, new Object[0]);
                        OutOfMemoryError outOfMemoryError = new OutOfMemoryError("loading field [" + fieldName + "] caused out of memory failure");
                        outOfMemoryError.initCause(e);
                        throw outOfMemoryError;
                    }
                }
            }
        }
        return fieldData;
    }

    protected abstract Cache<String, FieldData> buildFieldDataMap();
}

