/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.AttributeSource;

public abstract class NumericTokenizer
extends Tokenizer {
    private final NumericTokenStream numericTokenStream;
    protected final Object extra;

    protected NumericTokenizer(Reader reader, NumericTokenStream numericTokenStream, Object extra) throws IOException {
        super((AttributeSource)numericTokenStream);
        this.numericTokenStream = numericTokenStream;
        this.extra = extra;
        this.reset(reader);
    }

    protected NumericTokenizer(Reader reader, NumericTokenStream numericTokenStream, char[] buffer, Object extra) throws IOException {
        super((AttributeSource)numericTokenStream);
        this.numericTokenStream = numericTokenStream;
        this.extra = extra;
        this.reset(reader, buffer);
    }

    public void reset(Reader input) throws IOException {
        char[] buffer = new char[32];
        this.reset(input, buffer);
    }

    public void reset(Reader input, char[] buffer) throws IOException {
        super.reset(input);
        int len = input.read(buffer);
        String value = new String(buffer, 0, len);
        this.setValue(this.numericTokenStream, value);
        this.numericTokenStream.reset();
    }

    public final boolean incrementToken() throws IOException {
        return this.numericTokenStream.incrementToken();
    }

    protected abstract void setValue(NumericTokenStream var1, String var2);
}

