/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.membership;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class MembershipAction
extends AbstractComponent {
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final MembershipListener listener;

    public MembershipAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, MembershipListener listener) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        transportService.registerHandler("discovery/zen/join", new JoinRequestRequestHandler());
        transportService.registerHandler("discovery/zen/leave", new LeaveRequestRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler("discovery/zen/join");
        this.transportService.removeHandler("discovery/zen/leave");
    }

    public void sendLeaveRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(node, "discovery/zen/leave", new LeaveRequest(masterNode), VoidTransportResponseHandler.INSTANCE_SAME);
    }

    public void sendLeaveRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) throws ElasticSearchException {
        this.transportService.submitRequest(masterNode, "discovery/zen/leave", new LeaveRequest(node), VoidTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendJoinRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(masterNode, "discovery/zen/join", new JoinRequest(node, false), VoidTransportResponseHandler.INSTANCE_SAME);
    }

    public ClusterState sendJoinRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) throws ElasticSearchException {
        return this.transportService.submitRequest((DiscoveryNode)masterNode, (String)"discovery/zen/join", (Streamable)new JoinRequest((DiscoveryNode)node, (boolean)true), new FutureTransportResponseHandler<JoinResponse>(){

            @Override
            public JoinResponse newInstance() {
                return new JoinResponse();
            }
        }).txGet((long)timeout.millis(), (TimeUnit)TimeUnit.MILLISECONDS).clusterState;
    }

    private class LeaveRequestRequestHandler
    extends BaseTransportRequestHandler<LeaveRequest> {
        static final String ACTION = "discovery/zen/leave";

        private LeaveRequestRequestHandler() {
        }

        @Override
        public LeaveRequest newInstance() {
            return new LeaveRequest();
        }

        @Override
        public void messageReceived(LeaveRequest request, TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onLeave(request.node);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class LeaveRequest
    implements Streamable {
        private DiscoveryNode node;

        private LeaveRequest() {
        }

        private LeaveRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.node = DiscoveryNode.readNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
        }
    }

    private class JoinRequestRequestHandler
    extends BaseTransportRequestHandler<JoinRequest> {
        static final String ACTION = "discovery/zen/join";

        private JoinRequestRequestHandler() {
        }

        @Override
        public JoinRequest newInstance() {
            return new JoinRequest();
        }

        @Override
        public void messageReceived(JoinRequest request, TransportChannel channel) throws Exception {
            ClusterState clusterState = MembershipAction.this.listener.onJoin(request.node);
            if (request.withClusterState) {
                channel.sendResponse(new JoinResponse(clusterState));
            } else {
                channel.sendResponse(VoidStreamable.INSTANCE);
            }
        }

        @Override
        public String executor() {
            return "generic";
        }
    }

    class JoinResponse
    implements Streamable {
        ClusterState clusterState;

        JoinResponse() {
        }

        JoinResponse(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.clusterState = ClusterState.Builder.readFrom(in, MembershipAction.this.nodesProvider.nodes().localNode());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ClusterState.Builder.writeTo(this.clusterState, out);
        }
    }

    static class JoinRequest
    implements Streamable {
        DiscoveryNode node;
        boolean withClusterState;

        private JoinRequest() {
        }

        private JoinRequest(DiscoveryNode node, boolean withClusterState) {
            this.node = node;
            this.withClusterState = withClusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.node = DiscoveryNode.readNode(in);
            this.withClusterState = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            out.writeBoolean(this.withClusterState);
        }
    }

    public static interface MembershipListener {
        public ClusterState onJoin(DiscoveryNode var1);

        public void onLeave(DiscoveryNode var1);
    }
}

