/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface ToXContent {
    public static final Params EMPTY_PARAMS = new Params(){

        @Override
        public String param(String key) {
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
            return defaultValue;
        }
    };

    public XContentBuilder toXContent(XContentBuilder var1, Params var2) throws IOException;

    public static class MapParams
    implements Params {
        private final Map<String, String> params;

        public MapParams(Map<String, String> params) {
            this.params = params;
        }

        @Override
        public String param(String key) {
            return this.params.get(key);
        }

        @Override
        public String param(String key, String defaultValue) {
            String value = this.params.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return Booleans.parseBoolean(this.param(key), defaultValue);
        }

        @Override
        public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
            String sValue = this.param(key);
            if (sValue == null) {
                return defaultValue;
            }
            return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
        }
    }

    public static interface Params {
        public String param(String var1);

        public String param(String var1, String var2);

        public boolean paramAsBoolean(String var1, boolean var2);

        public Boolean paramAsBooleanOptional(String var1, Boolean var2);
    }
}

