/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.SizeUnit;

public class SizeValue
implements Serializable,
Streamable {
    private long size;
    private SizeUnit sizeUnit;

    private SizeValue() {
    }

    public SizeValue(long singles) {
        this(singles, SizeUnit.SINGLE);
    }

    public SizeValue(long size, SizeUnit sizeUnit) {
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    public long singles() {
        return this.sizeUnit.toSingles(this.size);
    }

    public long getSingles() {
        return this.singles();
    }

    public long kilo() {
        return this.sizeUnit.toKilo(this.size);
    }

    public long getKilo() {
        return this.kilo();
    }

    public long mega() {
        return this.sizeUnit.toMega(this.size);
    }

    public long getMega() {
        return this.mega();
    }

    public long giga() {
        return this.sizeUnit.toGiga(this.size);
    }

    public long getGiga() {
        return this.giga();
    }

    public double kiloFrac() {
        return (double)this.singles() / 1000.0;
    }

    public double getKiloFrac() {
        return this.kiloFrac();
    }

    public double megaFrac() {
        return (double)this.singles() / 1000000.0;
    }

    public double getMegaFrac() {
        return this.megaFrac();
    }

    public double gigaFrac() {
        return (double)this.singles() / 1.0E9;
    }

    public double getGigaFrac() {
        return this.gigaFrac();
    }

    public String toString() {
        long singles = this.singles();
        double value = singles;
        String suffix = "";
        if (singles >= 1000000000L) {
            value = this.gigaFrac();
            suffix = "g";
        } else if (singles >= 1000000L) {
            value = this.megaFrac();
            suffix = "m";
        } else if (singles >= 1000L) {
            value = this.kiloFrac();
            suffix = "k";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static SizeValue parseSizeValue(String sValue) throws ElasticSearchParseException {
        return SizeValue.parseSizeValue(sValue, null);
    }

    public static SizeValue parseSizeValue(String sValue, SizeValue defaultValue) throws ElasticSearchParseException {
        long singles;
        if (sValue == null) {
            return defaultValue;
        }
        try {
            singles = sValue.endsWith("b") ? Long.parseLong(sValue.substring(0, sValue.length() - 1)) : (sValue.endsWith("k") || sValue.endsWith("K") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000.0) : (sValue.endsWith("m") || sValue.endsWith("M") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000000.0) : (sValue.endsWith("g") || sValue.endsWith("G") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1.0E9) : Long.parseLong(sValue))));
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchParseException("Failed to parse [" + sValue + "]", e);
        }
        return new SizeValue(singles, SizeUnit.SINGLE);
    }

    public static SizeValue readSizeValue(StreamInput in) throws IOException {
        SizeValue sizeValue = new SizeValue();
        sizeValue.readFrom(in);
        return sizeValue;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.size = in.readVLong();
        this.sizeUnit = SizeUnit.SINGLE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.singles());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeValue sizeValue = (SizeValue)o;
        if (this.size != sizeValue.size) {
            return false;
        }
        return this.sizeUnit == sizeValue.sizeUnit;
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.sizeUnit != null ? this.sizeUnit.hashCode() : 0);
        return result;
    }
}

