/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.nio;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelException;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.socket.nio.AbstractNioChannelSink;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioSocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioWorker;
import org.elasticsearch.common.netty.channel.socket.nio.WorkerPool;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.ThreadRenamingRunnable;
import org.elasticsearch.common.netty.util.internal.DeadLockProofWorker;
import org.elasticsearch.common.netty.util.internal.QueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioClientSocketPipelineSink
extends AbstractNioChannelSink {
    private static final AtomicInteger nextId = new AtomicInteger();
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketPipelineSink.class);
    final Executor bossExecutor;
    final int id = nextId.incrementAndGet();
    private final Boss[] bosses;
    private final AtomicInteger bossIndex = new AtomicInteger();
    private final WorkerPool<NioWorker> workerPool;

    NioClientSocketPipelineSink(Executor bossExecutor, int bossCount, WorkerPool<NioWorker> workerPool) {
        this.bossExecutor = bossExecutor;
        this.bosses = new Boss[bossCount];
        for (int i = 0; i < this.bosses.length; ++i) {
            this.bosses[i] = new Boss(i);
        }
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioClientSocketChannel channel = (NioClientSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        NioClientSocketPipelineSink.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void bind(NioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            ((SocketChannel)channel.channel).socket().bind(localAddress);
            channel.boundManually = true;
            channel.setBound();
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(NioClientSocketChannel channel, final ChannelFuture cf, SocketAddress remoteAddress) {
        try {
            if (((SocketChannel)channel.channel).connect(remoteAddress)) {
                channel.worker.register(channel, cf);
            } else {
                channel.getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (!cf.isDone()) {
                            cf.setFailure(new ClosedChannelException());
                        }
                    }
                });
                cf.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.connectFuture = cf;
                this.nextBoss().register(channel);
            }
        }
        catch (Throwable t) {
            cf.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
            channel.worker.close(channel, Channels.succeededFuture(channel));
        }
    }

    Boss nextBoss() {
        return this.bosses[Math.abs(this.bossIndex.getAndIncrement() % this.bosses.length)];
    }

    NioWorker nextWorker() {
        return this.workerPool.nextWorker();
    }

    private static final class RegisterTask
    implements Runnable {
        private final Boss boss;
        private final NioClientSocketChannel channel;

        RegisterTask(Boss boss, NioClientSocketChannel channel) {
            this.boss = boss;
            this.channel = channel;
        }

        public void run() {
            try {
                ((SocketChannel)this.channel.channel).register(this.boss.selector, 8, this.channel);
            }
            catch (ClosedChannelException e) {
                this.channel.worker.close(this.channel, Channels.succeededFuture(this.channel));
            }
            int connectTimeout = this.channel.getConfig().getConnectTimeoutMillis();
            if (connectTimeout > 0) {
                this.channel.connectDeadlineNanos = System.nanoTime() + (long)connectTimeout * 1000000L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Boss
    implements Runnable {
        volatile Selector selector;
        private boolean started;
        private final AtomicBoolean wakenUp = new AtomicBoolean();
        private final Object startStopLock = new Object();
        private final Queue<Runnable> registerTaskQueue = QueueFactory.createQueue(Runnable.class);
        private final int subId;

        Boss(int subId) {
            this.subId = subId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(NioClientSocketChannel channel) {
            Selector selector;
            RegisterTask registerTask = new RegisterTask(this, channel);
            Object object = this.startStopLock;
            synchronized (object) {
                block15: {
                    if (!this.started) {
                        block16: {
                            try {
                                this.selector = selector = Selector.open();
                            }
                            catch (Throwable t) {
                                throw new ChannelException("Failed to create a selector.", t);
                            }
                            boolean success = false;
                            try {
                                DeadLockProofWorker.start(NioClientSocketPipelineSink.this.bossExecutor, new ThreadRenamingRunnable(this, "New I/O client boss #" + NioClientSocketPipelineSink.this.id + '-' + this.subId));
                                success = true;
                                Object var7_7 = null;
                                if (success) break block15;
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                if (!success) {
                                    block17: {
                                        try {
                                            selector.close();
                                        }
                                        catch (Throwable t) {
                                            if (!logger.isWarnEnabled()) break block17;
                                            logger.warn("Failed to close a selector.", t);
                                        }
                                    }
                                    selector = null;
                                    this.selector = null;
                                }
                                throw throwable;
                            }
                            try {
                                selector.close();
                            }
                            catch (Throwable t) {
                                if (!logger.isWarnEnabled()) break block16;
                                logger.warn("Failed to close a selector.", t);
                            }
                        }
                        selector = null;
                        this.selector = null;
                        {
                            break block15;
                        }
                    }
                    selector = this.selector;
                }
                assert (selector != null && selector.isOpen());
                this.started = true;
                boolean offered = this.registerTaskQueue.offer(registerTask);
                assert (offered);
            }
            if (this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdown = false;
            Selector selector = this.selector;
            long lastConnectTimeoutCheckTimeNanos = System.nanoTime();
            while (true) {
                this.wakenUp.set(false);
                try {
                    long currentTimeNanos;
                    int selectedKeyCount = selector.select(10L);
                    if (this.wakenUp.get()) {
                        selector.wakeup();
                    }
                    this.processRegisterTaskQueue();
                    if (selectedKeyCount > 0) {
                        this.processSelectedKeys(selector.selectedKeys());
                    }
                    if ((currentTimeNanos = System.nanoTime()) - lastConnectTimeoutCheckTimeNanos >= 10000000L) {
                        lastConnectTimeoutCheckTimeNanos = currentTimeNanos;
                        this.processConnectTimeout(selector.keys(), currentTimeNanos);
                    }
                    if (selector.keys().isEmpty()) {
                        if (shutdown || NioClientSocketPipelineSink.this.bossExecutor instanceof ExecutorService && ((ExecutorService)NioClientSocketPipelineSink.this.bossExecutor).isShutdown()) {
                            Object object = this.startStopLock;
                            synchronized (object) {
                                if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                    this.started = false;
                                    try {
                                        try {
                                            selector.close();
                                        }
                                        catch (IOException e) {
                                            if (logger.isWarnEnabled()) {
                                                logger.warn("Failed to close a selector.", e);
                                            }
                                            Object var11_10 = null;
                                            this.selector = null;
                                        }
                                        Object var11_9 = null;
                                        this.selector = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_11 = null;
                                        this.selector = null;
                                        throw throwable;
                                    }
                                    break;
                                }
                                shutdown = false;
                                continue;
                            }
                        }
                        shutdown = true;
                        continue;
                    }
                    shutdown = false;
                }
                catch (Throwable t) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Unexpected exception in the selector loop.", t);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private void processRegisterTaskQueue() {
            Runnable task;
            while ((task = this.registerTaskQueue.poll()) != null) {
                task.run();
            }
        }

        private void processSelectedKeys(Set<SelectionKey> selectedKeys) {
            Iterator<SelectionKey> i = selectedKeys.iterator();
            while (i.hasNext()) {
                SelectionKey k = i.next();
                i.remove();
                if (!k.isValid()) {
                    this.close(k);
                    continue;
                }
                if (!k.isConnectable()) continue;
                this.connect(k);
            }
        }

        private void processConnectTimeout(Set<SelectionKey> keys, long currentTimeNanos) {
            ConnectException cause = null;
            for (SelectionKey k : keys) {
                if (!k.isValid()) continue;
                NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
                if (ch.connectDeadlineNanos <= 0L || currentTimeNanos < ch.connectDeadlineNanos) continue;
                if (cause == null) {
                    cause = new ConnectException("connection timed out");
                }
                ch.connectFuture.setFailure(cause);
                Channels.fireExceptionCaught(ch, (Throwable)cause);
                ch.worker.close(ch, Channels.succeededFuture(ch));
            }
        }

        private void connect(SelectionKey k) {
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            try {
                if (((SocketChannel)ch.channel).finishConnect()) {
                    k.cancel();
                    ch.worker.register(ch, ch.connectFuture);
                }
            }
            catch (Throwable t) {
                ch.connectFuture.setFailure(t);
                Channels.fireExceptionCaught(ch, t);
                k.cancel();
                ch.worker.close(ch, Channels.succeededFuture(ch));
            }
        }

        private void close(SelectionKey k) {
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            ch.worker.close(ch, Channels.succeededFuture(ch));
        }
    }
}

