/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.Operator;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ScriptRuntimeException;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.ast.BooleanNode;
import org.elasticsearch.common.mvel2.ast.LiteralNode;
import org.elasticsearch.common.mvel2.debug.DebugTools;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.math.MathProcessor;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class BinaryOperation
extends BooleanNode {
    private final int operation;
    private int lType = -1;
    private int rType = -1;

    public BinaryOperation(int operation) {
        this.operation = operation;
    }

    public BinaryOperation(int operation, ASTNode left, ASTNode right) {
        this.operation = operation;
        this.left = left;
        if (this.left == null) {
            throw new RuntimeException("not a statement");
        }
        this.right = right;
        if (this.right == null) {
            throw new RuntimeException("not a statement");
        }
        this.egressType = CompilerTools.getReturnTypeFromOp(operation, left.egressType, right.egressType);
    }

    public BinaryOperation(int operation, ASTNode left, ASTNode right, ParserContext ctx) {
        this.operation = operation;
        this.left = left;
        if (this.left == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        this.right = right;
        if (this.right == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        switch (operation) {
            case 0: {
                if (left.getEgressType() != String.class && right.getEgressType() != String.class) break;
                this.egressType = String.class;
                this.lType = ParseTools.__resolveType(left.egressType);
                this.rType = ParseTools.__resolveType(right.egressType);
                return;
            }
        }
        if (ctx.isStrongTyping() && !left.getEgressType().isAssignableFrom(right.getEgressType())) {
            if (right.isLiteral() && DataConversion.canConvert(right.getEgressType(), left.getEgressType())) {
                this.right = new LiteralNode(DataConversion.convert(right.getReducedValueAccelerated(null, null, null), left.getEgressType()));
            } else if (!(right.getEgressType().equals(Object.class) || Number.class.isAssignableFrom(right.getEgressType()) && Number.class.isAssignableFrom(left.getEgressType()) || (right.getEgressType().isPrimitive() || left.getEgressType().isPrimitive()) && DataConversion.canConvert(ParseTools.boxPrimitive(left.getEgressType()), ParseTools.boxPrimitive(right.getEgressType())))) {
                throw new CompileException("incompatible types in statement: " + right.getEgressType() + " (compared from: " + left.getEgressType() + ")", left.getExpr(), left.getStart());
            }
        }
        if (this.left.isLiteral() && this.right.isLiteral()) {
            if (this.left.egressType == this.right.egressType) {
                this.lType = this.rType = ParseTools.__resolveType(left.egressType);
            } else {
                this.lType = ParseTools.__resolveType(this.left.egressType);
                this.rType = ParseTools.__resolveType(this.right.egressType);
            }
        }
        this.egressType = CompilerTools.getReturnTypeFromOp(operation, this.left.egressType, this.right.egressType);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return MathProcessor.doOperations(this.lType, this.left.getReducedValueAccelerated(ctx, thisValue, factory), this.operation, this.rType, this.right.getReducedValueAccelerated(ctx, thisValue, factory));
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        throw new RuntimeException("unsupported AST operation");
    }

    public int getOperation() {
        return this.operation;
    }

    public BinaryOperation getRightBinary() {
        return this.right != null && this.right instanceof BinaryOperation ? (BinaryOperation)this.right : null;
    }

    public void setRightMost(ASTNode right) {
        BinaryOperation n = this;
        while (n.right != null && n.right instanceof BinaryOperation) {
            n = (BinaryOperation)n.right;
        }
        n.right = right;
        if (n == this && (this.rType = ParseTools.__resolveType(n.right.getEgressType())) == 0) {
            this.rType = -1;
        }
    }

    public ASTNode getRightMost() {
        BinaryOperation n = this;
        while (n.right != null && n.right instanceof BinaryOperation) {
            n = (BinaryOperation)n.right;
        }
        return n.right;
    }

    public int getPrecedence() {
        return Operator.PTABLE[this.operation];
    }

    public boolean isGreaterPrecedence(BinaryOperation o) {
        return o.getPrecedence() > Operator.PTABLE[this.operation];
    }

    public boolean isLiteral() {
        return false;
    }

    public String toString() {
        return "(" + this.left + " " + DebugTools.getOperatorSymbol(this.operation) + " " + this.right + ")";
    }
}

