/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class TermFilter
extends Filter {
    private final Term term;

    public TermFilter(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FixedBitSet result = null;
        TermDocs td = reader.termDocs();
        try {
            td.seek(this.term);
            int[] docs = new int[32];
            int[] freqs = new int[32];
            int number = td.read(docs, freqs);
            if (number > 0) {
                result = new FixedBitSet(reader.maxDoc());
                while (number > 0) {
                    for (int i = 0; i < number; ++i) {
                        result.set(docs[i]);
                    }
                    number = td.read(docs, freqs);
                }
            }
        }
        finally {
            td.close();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TermFilter that = (TermFilter)((Object)o);
        return !(this.term != null ? !this.term.equals((Object)that.term) : that.term != null);
    }

    public int hashCode() {
        return this.term != null ? this.term.hashCode() : 0;
    }

    public String toString() {
        return this.term.field() + ":" + this.term.text();
    }
}

