/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.OrDocIdSet;
import org.elasticsearch.common.lucene.docset.OrDocSet;

public class OrFilter
extends Filter {
    private final List<? extends Filter> filters;

    public OrFilter(List<? extends Filter> filters) {
        this.filters = filters;
    }

    public List<? extends Filter> filters() {
        return this.filters;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getDocIdSet(reader);
        }
        ArrayList<DocIdSet> sets = Lists.newArrayListWithExpectedSize(this.filters.size());
        boolean allAreDocSet = true;
        for (Filter filter : this.filters) {
            DocIdSet set = filter.getDocIdSet(reader);
            if (set == null) continue;
            if (!(set instanceof DocSet)) {
                allAreDocSet = false;
            }
            sets.add(set);
        }
        if (sets.size() == 0) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (sets.size() == 1) {
            return (DocIdSet)sets.get(0);
        }
        if (allAreDocSet) {
            return new OrDocSet(sets);
        }
        return new OrDocIdSet(sets);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.filters ? 0 : ((Object)this.filters).hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OrFilter other = (OrFilter)((Object)obj);
        return this.equalFilters(this.filters, other.filters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Filter filter : this.filters) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(filter);
        }
        return builder.toString();
    }

    private boolean equalFilters(List<? extends Filter> filters1, List<? extends Filter> filters2) {
        return filters1 == filters2 || filters1 != null && ((Object)filters1).equals(filters2);
    }
}

