/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public final class MatchNoDocsQuery
extends Query {
    public static MatchNoDocsQuery INSTANCE = new MatchNoDocsQuery();
    private static final int HASH_CODE = 12345;

    public Weight createWeight(Searcher searcher) {
        return new MatchNoDocsWeight(searcher);
    }

    public void extractTerms(Set<Term> terms) {
    }

    public String toString(String field) {
        return "MatchNoDocsQuery";
    }

    public boolean equals(Object o) {
        return o instanceof MatchAllDocsQuery;
    }

    public int hashCode() {
        return 12345;
    }

    private class MatchNoDocsWeight
    extends Weight {
        private final Similarity similarity;

        public MatchNoDocsWeight(Searcher searcher) {
            this.similarity = searcher.getSimilarity();
        }

        public String toString() {
            return "weight(" + (Object)((Object)MatchNoDocsQuery.this) + ")";
        }

        public Query getQuery() {
            return MatchNoDocsQuery.this;
        }

        public float getValue() {
            return 0.0f;
        }

        public float sumOfSquaredWeights() {
            return 0.0f;
        }

        public void normalize(float queryNorm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return null;
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new ComplexExplanation(false, 0.0f, "MatchNoDocs matches nothing");
        }
    }
}

