/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;

public class CompressorFactory {
    private static final LZFCompressor LZF = new LZFCompressor();
    private static final Compressor[] compressors = new Compressor[1];
    private static final ImmutableMap<String, Compressor> compressorsByType;

    public static Compressor defaultCompressor() {
        return LZF;
    }

    public static boolean isCompressed(byte[] data) {
        return CompressorFactory.compressor(data, 0, data.length) != null;
    }

    public static boolean isCompressed(byte[] data, int offset, int length) {
        return CompressorFactory.compressor(data, offset, length) != null;
    }

    public static boolean isCompressed(IndexInput in) throws IOException {
        return CompressorFactory.compressor(in) != null;
    }

    @Nullable
    public static Compressor compressor(BytesHolder bytes) {
        return CompressorFactory.compressor(bytes.bytes(), bytes.offset(), bytes.length());
    }

    @Nullable
    public static Compressor compressor(byte[] data) {
        return CompressorFactory.compressor(data, 0, data.length);
    }

    @Nullable
    public static Compressor compressor(byte[] data, int offset, int length) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(data, offset, length)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(ChannelBuffer buffer) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(buffer)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(IndexInput in) throws IOException {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(in)) continue;
            return compressor;
        }
        return null;
    }

    public static Compressor compressor(String type) {
        return compressorsByType.get(type);
    }

    public static BytesHolder uncompressIfNeeded(BytesHolder bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            return new BytesHolder(compressor.uncompress(bytes.bytes(), bytes.offset(), bytes.length()));
        }
        return bytes;
    }

    static {
        CompressorFactory.compressors[0] = LZF;
        MapBuilder<String, Compressor> compressorsByTypeX = MapBuilder.newMapBuilder();
        for (Compressor compressor : compressors) {
            compressorsByTypeX.put(compressor.type(), compressor);
        }
        compressorsByType = compressorsByTypeX.immutableMap();
    }
}

