/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class CompressedString
implements Streamable {
    private byte[] bytes;

    CompressedString() {
    }

    public CompressedString(byte[] compressed) {
        this.bytes = compressed;
    }

    public CompressedString(byte[] data, int offset, int length) throws IOException {
        Compressor compressor = CompressorFactory.compressor(data, offset, length);
        this.bytes = compressor != null ? Arrays.copyOfRange(data, offset, offset + length) : CompressorFactory.defaultCompressor().compress(data, offset, length);
    }

    public CompressedString(String str) throws IOException {
        UnicodeUtil.UTF8Result result = Unicode.unsafeFromStringAsUtf8(str);
        this.bytes = CompressorFactory.defaultCompressor().compress(result.result, 0, result.length);
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public byte[] uncompressed() throws IOException {
        Compressor compressor = CompressorFactory.compressor(this.bytes);
        return compressor.uncompress(this.bytes, 0, this.bytes.length);
    }

    public String string() throws IOException {
        return Unicode.fromBytes(this.uncompressed());
    }

    public static CompressedString readCompressedString(StreamInput in) throws IOException {
        CompressedString compressedString = new CompressedString();
        compressedString.readFrom(in);
        return compressedString;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.bytes = new byte[in.readVInt()];
        in.readBytes(this.bytes, 0, this.bytes.length);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.bytes.length);
        out.writeBytes(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedString that = (CompressedString)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.bytes != null ? Arrays.hashCode(this.bytes) : 0;
    }

    public String toString() {
        try {
            return this.string();
        }
        catch (IOException e) {
            return "_na_";
        }
    }
}

