/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Arrays;
import org.elasticsearch.common.Bytes;

public class BytesHolder {
    public static final BytesHolder EMPTY = new BytesHolder(Bytes.EMPTY_ARRAY, 0, 0);
    private byte[] bytes;
    private int offset;
    private int length;

    BytesHolder() {
    }

    public BytesHolder(byte[] bytes) {
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public BytesHolder(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public boolean equals(Object obj) {
        return this.bytesEquals((BytesHolder)obj);
    }

    public boolean bytesEquals(BytesHolder other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.bytes[upto] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = 31 * result + this.bytes[i];
        }
        return result;
    }
}

