/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DisableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;

public class AllocationDecidersModule
extends AbstractModule {
    private final Settings settings;
    private List<Class<? extends AllocationDecider>> allocations = Lists.newArrayList();

    public AllocationDecidersModule(Settings settings) {
        this.settings = settings;
    }

    public AllocationDecidersModule add(Class<? extends AllocationDecider> allocationDecider) {
        this.allocations.add(allocationDecider);
        return this;
    }

    @Override
    protected void configure() {
        Multibinder<AllocationDecider> allocationMultibinder = Multibinder.newSetBinder(this.binder(), AllocationDecider.class);
        allocationMultibinder.addBinding().to(SameShardAllocationDecider.class);
        allocationMultibinder.addBinding().to(FilterAllocationDecider.class);
        allocationMultibinder.addBinding().to(ReplicaAfterPrimaryActiveAllocationDecider.class);
        allocationMultibinder.addBinding().to(ThrottlingAllocationDecider.class);
        allocationMultibinder.addBinding().to(RebalanceOnlyWhenActiveAllocationDecider.class);
        allocationMultibinder.addBinding().to(ClusterRebalanceAllocationDecider.class);
        allocationMultibinder.addBinding().to(ConcurrentRebalanceAllocationDecider.class);
        allocationMultibinder.addBinding().to(DisableAllocationDecider.class);
        allocationMultibinder.addBinding().to(AwarenessAllocationDecider.class);
        allocationMultibinder.addBinding().to(ShardsLimitAllocationDecider.class);
        for (Class<? extends AllocationDecider> allocation : this.allocations) {
            allocationMultibinder.addBinding().to(allocation);
        }
        this.bind(AllocationDeciders.class).asEagerSingleton();
    }
}

