/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import org.elasticsearch.cluster.routing.allocation.allocator.EvenShardsCountAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.GatewayAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.none.NoneGatewayAllocator;

public class ShardsAllocatorModule
extends AbstractModule {
    private Settings settings;
    private Class<? extends ShardsAllocator> shardsAllocator;
    private Class<? extends GatewayAllocator> gatewayAllocator = NoneGatewayAllocator.class;

    public ShardsAllocatorModule(Settings settings) {
        this.settings = settings;
    }

    public void setGatewayAllocator(Class<? extends GatewayAllocator> gatewayAllocator) {
        this.gatewayAllocator = gatewayAllocator;
    }

    public void setShardsAllocator(Class<? extends ShardsAllocator> shardsAllocator) {
        this.shardsAllocator = shardsAllocator;
    }

    @Override
    protected void configure() {
        this.bind(GatewayAllocator.class).to(this.gatewayAllocator).asEagerSingleton();
        this.bind(ShardsAllocator.class).to(this.shardsAllocator == null ? EvenShardsCountAllocator.class : this.shardsAllocator).asEagerSingleton();
    }
}

