/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocators;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class AllocationService
extends AbstractComponent {
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocators shardsAllocators;

    public AllocationService() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public AllocationService(Settings settings) {
        this(settings, new AllocationDeciders(settings, new NodeSettingsService(ImmutableSettings.Builder.EMPTY_SETTINGS)), new ShardsAllocators(settings));
    }

    @Inject
    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocators shardsAllocators) {
        super(settings);
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocators = shardsAllocators;
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        StartedRerouteAllocation allocation = new StartedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), startedShards);
        boolean changed = this.applyStartedShards(routingNodes, startedShards);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.shardsAllocators.applyStartedShards(allocation);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        FailedRerouteAllocation allocation = new FailedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), failedShard);
        boolean changed = this.applyFailedShard(allocation);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.shardsAllocators.applyFailedShards(allocation);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes());
        if (!this.reroute(allocation)) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result rerouteWithNoReassign(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        Collections.shuffle(routingNodes.unassigned());
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes());
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation.routingNodes(), dataNodes);
        this.applyNewNodes(allocation.routingNodes(), dataNodes);
        if (!(changed |= this.electPrimaries(allocation.routingNodes()))) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    private boolean reroute(RoutingAllocation allocation) {
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation.routingNodes(), dataNodes);
        this.applyNewNodes(allocation.routingNodes(), dataNodes);
        changed |= this.electPrimaries(allocation.routingNodes());
        if (allocation.routingNodes().hasUnassigned()) {
            changed |= this.shardsAllocators.allocateUnassigned(allocation);
            changed |= this.electPrimaries(allocation.routingNodes());
        }
        changed |= this.moveShards(allocation);
        return changed |= this.shardsAllocators.rebalance(allocation);
    }

    private boolean moveShards(RoutingAllocation allocation) {
        boolean changed = false;
        ArrayList<MutableShardRouting> shards = new ArrayList<MutableShardRouting>();
        int index = 0;
        boolean found = true;
        while (found) {
            found = false;
            for (RoutingNode routingNode : allocation.routingNodes()) {
                if (index >= routingNode.shards().size()) continue;
                found = true;
                shards.add(routingNode.shards().get(index));
            }
            ++index;
        }
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting shardRouting = (MutableShardRouting)shards.get(i);
            if (!shardRouting.started()) continue;
            RoutingNode routingNode = allocation.routingNodes().node(shardRouting.currentNodeId());
            if (allocation.deciders().canRemain(shardRouting, routingNode, allocation)) continue;
            this.logger.debug("[{}][{}] allocated on [{}], but can no longer be allocated on it, moving...", shardRouting.index(), shardRouting.id(), routingNode.node());
            boolean moved = this.shardsAllocators.move(shardRouting, routingNode, allocation);
            if (!moved) {
                this.logger.debug("[{}][{}] can't move", shardRouting.index(), shardRouting.id());
                continue;
            }
            changed = true;
        }
        return changed;
    }

    private boolean electPrimaries(RoutingNodes routingNodes) {
        boolean changed = false;
        block0: for (MutableShardRouting shardEntry : routingNodes.unassigned()) {
            if (!shardEntry.primary() || shardEntry.assignedToNode()) continue;
            boolean elected = false;
            for (RoutingNode routingNode : routingNodes.nodesToShards().values()) {
                for (MutableShardRouting shardEntry2 : routingNode.shards()) {
                    RoutingNode node;
                    if (!shardEntry.shardId().equals(shardEntry2.shardId()) || !shardEntry2.active()) continue;
                    assert (shardEntry2.assignedToNode());
                    assert (!shardEntry2.primary());
                    changed = true;
                    shardEntry.moveFromPrimary();
                    shardEntry2.moveToPrimary();
                    if (shardEntry2.relocatingNodeId() != null && (node = routingNodes.node(shardEntry2.relocatingNodeId())) != null) {
                        for (MutableShardRouting shardRouting : node) {
                            if (!shardRouting.shardId().equals(shardEntry2.shardId()) || shardRouting.primary()) continue;
                            shardRouting.moveToPrimary();
                            break;
                        }
                    }
                    elected = true;
                    break;
                }
                if (!elected) continue;
                continue block0;
            }
        }
        return changed;
    }

    private void applyNewNodes(RoutingNodes routingNodes, Iterable<DiscoveryNode> liveNodes) {
        for (DiscoveryNode node : liveNodes) {
            if (routingNodes.nodesToShards().containsKey(node.id())) continue;
            RoutingNode routingNode = new RoutingNode(node.id(), node);
            routingNodes.nodesToShards().put(node.id(), routingNode);
        }
    }

    private boolean deassociateDeadNodes(RoutingNodes routingNodes, Iterable<DiscoveryNode> liveNodes) {
        MutableShardRouting shardRoutingEntry;
        Iterator<MutableShardRouting> shardsIterator;
        boolean changed = false;
        HashSet<String> liveNodeIds = Sets.newHashSet();
        for (DiscoveryNode liveNode : liveNodes) {
            liveNodeIds.add(liveNode.id());
        }
        HashSet<String> nodeIdsToRemove = Sets.newHashSet();
        for (RoutingNode routingNode : routingNodes) {
            shardsIterator = routingNode.shards().iterator();
            while (shardsIterator.hasNext()) {
                shardRoutingEntry = shardsIterator.next();
                if (!shardRoutingEntry.assignedToNode()) {
                    throw new ElasticSearchIllegalStateException(shardRoutingEntry.shardId() + " is not assigned to a node, but listed on as existing on node [" + routingNode.nodeId() + "]");
                }
                boolean relocating = shardRoutingEntry.relocating();
                String relocatingNodeId = shardRoutingEntry.relocatingNodeId();
                boolean isRelocationDestinationShard = relocatingNodeId != null && shardRoutingEntry.initializing();
                boolean remove = false;
                boolean currentNodeIsDead = false;
                if (!liveNodeIds.contains(shardRoutingEntry.currentNodeId())) {
                    changed = true;
                    nodeIdsToRemove.add(shardRoutingEntry.currentNodeId());
                    if (!isRelocationDestinationShard) {
                        routingNodes.unassigned().add(shardRoutingEntry);
                    }
                    shardRoutingEntry.deassignNode();
                    currentNodeIsDead = true;
                    remove = true;
                }
                if (relocating && !liveNodeIds.contains(relocatingNodeId)) {
                    nodeIdsToRemove.add(relocatingNodeId);
                    if (!currentNodeIsDead) {
                        changed = true;
                        shardRoutingEntry.cancelRelocation();
                    }
                }
                if (isRelocationDestinationShard && !liveNodeIds.contains(relocatingNodeId)) {
                    changed = true;
                    remove = true;
                }
                if (!remove) continue;
                shardsIterator.remove();
            }
        }
        for (String nodeIdToRemove : nodeIdsToRemove) {
            routingNodes.nodesToShards().remove(nodeIdToRemove);
        }
        for (RoutingNode routingNode : routingNodes) {
            shardsIterator = routingNode.shards().iterator();
            block5: while (shardsIterator.hasNext()) {
                shardRoutingEntry = shardsIterator.next();
                if (!shardRoutingEntry.assignedToNode()) {
                    throw new ElasticSearchIllegalStateException(shardRoutingEntry.shardId() + " is not assigned to a node, but listed on as existing on node [" + routingNode.nodeId() + "]");
                }
                if (shardRoutingEntry.primary() || !shardRoutingEntry.initializing() || shardRoutingEntry.relocatingNodeId() != null) continue;
                for (MutableShardRouting unassignedShardRouting : routingNodes.unassigned()) {
                    if (!unassignedShardRouting.shardId().equals(shardRoutingEntry.shardId()) || !unassignedShardRouting.primary()) continue;
                    routingNodes.unassigned().add(shardRoutingEntry);
                    shardRoutingEntry.deassignNode();
                    shardsIterator.remove();
                    continue block5;
                }
            }
        }
        return changed;
    }

    private boolean applyStartedShards(RoutingNodes routingNodes, Iterable<? extends ShardRouting> startedShardEntries) {
        boolean dirty = false;
        block0: for (ShardRouting shardRouting : startedShardEntries) {
            RoutingNode sourceRoutingNode;
            assert (shardRouting.state() == ShardRoutingState.INITIALIZING);
            String relocatingNodeId = null;
            RoutingNode currentRoutingNode = routingNodes.nodesToShards().get(shardRouting.currentNodeId());
            if (currentRoutingNode != null) {
                for (MutableShardRouting shard : currentRoutingNode) {
                    if (!shard.shardId().equals(shardRouting.shardId())) continue;
                    relocatingNodeId = shard.relocatingNodeId();
                    if (shard.started()) break;
                    dirty = true;
                    shard.moveToStarted();
                    break;
                }
            }
            if (relocatingNodeId == null || (sourceRoutingNode = routingNodes.nodesToShards().get(relocatingNodeId)) == null) continue;
            Iterator<MutableShardRouting> shardsIter = sourceRoutingNode.iterator();
            while (shardsIter.hasNext()) {
                MutableShardRouting shard = shardsIter.next();
                if (!shard.shardId().equals(shardRouting.shardId()) || !shard.relocating()) continue;
                dirty = true;
                shardsIter.remove();
                continue block0;
            }
        }
        return dirty;
    }

    private boolean applyFailedShard(FailedRerouteAllocation allocation) {
        RoutingNode routingNode;
        boolean inRelocation;
        IndexRoutingTable indexRoutingTable = allocation.routingTable().index(allocation.failedShard().index());
        if (indexRoutingTable == null) {
            return false;
        }
        ShardRouting failedShard = allocation.failedShard();
        boolean shardDirty = false;
        boolean bl = inRelocation = failedShard.relocatingNodeId() != null;
        if (inRelocation && (routingNode = allocation.routingNodes().nodesToShards().get(failedShard.currentNodeId())) != null) {
            Iterator<MutableShardRouting> shards = routingNode.iterator();
            while (shards.hasNext()) {
                MutableShardRouting shard = shards.next();
                if (!shard.shardId().equals(failedShard.shardId())) continue;
                shardDirty = true;
                shard.deassignNode();
                shards.remove();
                break;
            }
        }
        String nodeId = inRelocation ? failedShard.relocatingNodeId() : failedShard.currentNodeId();
        RoutingNode currentRoutingNode = allocation.routingNodes().nodesToShards().get(nodeId);
        if (currentRoutingNode == null) {
            return false;
        }
        Iterator<MutableShardRouting> shards = currentRoutingNode.iterator();
        while (shards.hasNext()) {
            MutableShardRouting shard = shards.next();
            if (!shard.shardId().equals(failedShard.shardId())) continue;
            shardDirty = true;
            if (!inRelocation) {
                shard.deassignNode();
                shards.remove();
                break;
            }
            shard.cancelRelocation();
            break;
        }
        if (!shardDirty) {
            return false;
        }
        allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
        if (inRelocation) {
            return true;
        }
        ArrayList<MutableShardRouting> shardsToMove = Lists.newArrayList();
        Iterator<MutableShardRouting> it = allocation.routingNodes().unassigned().iterator();
        while (it.hasNext()) {
            MutableShardRouting shardRouting = it.next();
            if (!shardRouting.shardId().equals(failedShard.shardId())) continue;
            it.remove();
            shardsToMove.add(shardRouting);
        }
        if (!shardsToMove.isEmpty()) {
            allocation.routingNodes().unassigned().addAll(shardsToMove);
        }
        allocation.routingNodes().unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
        return true;
    }
}

