/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class MetaDataUpdateSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final AllocationService allocationService;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.clusterService = clusterService;
        this.clusterService.add(this);
        this.allocationService = allocationService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().localNodeMaster()) {
            return;
        }
        for (final IndexMetaData indexMetaData : event.state().metaData()) {
            String autoExpandReplicas = indexMetaData.settings().get("index.auto_expand_replicas");
            if (autoExpandReplicas == null || !Booleans.parseBoolean(autoExpandReplicas, true)) continue;
            try {
                int max;
                int min;
                try {
                    min = Integer.parseInt(autoExpandReplicas.substring(0, autoExpandReplicas.indexOf(45)));
                    String sMax = autoExpandReplicas.substring(autoExpandReplicas.indexOf(45) + 1);
                    max = sMax.equals("all") ? event.state().nodes().dataNodes().size() - 1 : Integer.parseInt(sMax);
                }
                catch (Exception e) {
                    this.logger.warn("failed to set [{}], wrong format [{}]", e, "index.auto_expand_replicas", autoExpandReplicas);
                    continue;
                }
                int numberOfReplicas = event.state().nodes().dataNodes().size() - 1;
                if (numberOfReplicas < min) {
                    numberOfReplicas = min;
                } else if (numberOfReplicas > max) {
                    numberOfReplicas = max;
                }
                if (numberOfReplicas == indexMetaData.numberOfReplicas() || numberOfReplicas < min || numberOfReplicas > max) continue;
                final int fNumberOfReplicas = numberOfReplicas;
                Settings settings = ImmutableSettings.settingsBuilder().put("index.number_of_replicas", fNumberOfReplicas).build();
                this.updateSettings(settings, new String[]{indexMetaData.index()}, new Listener(){

                    @Override
                    public void onSuccess() {
                        MetaDataUpdateSettingsService.this.logger.info("[{}] auto expanded replicas to [{}]", indexMetaData.index(), fNumberOfReplicas);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        MetaDataUpdateSettingsService.this.logger.warn("[{}] fail to auto expand replicas to [{}]", indexMetaData.index(), fNumberOfReplicas);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("[{}] failed to parse auto expand replicas", e, indexMetaData.index());
            }
        }
    }

    public void updateSettings(Settings pSettings, final String[] indices, final Listener listener) {
        ImmutableSettings.Builder updatedSettingsBuilder = ImmutableSettings.settingsBuilder();
        for (Map.Entry entry : pSettings.getAsMap().entrySet()) {
            if (((String)entry.getKey()).equals("index")) continue;
            if (!((String)entry.getKey()).startsWith("index.")) {
                updatedSettingsBuilder.put("index." + (String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            updatedSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (String key : updatedSettingsBuilder.internalMap().keySet()) {
            if (!key.equals("index.number_of_shards")) continue;
            listener.onFailure(new ElasticSearchIllegalArgumentException("can't change the number of shards for an index"));
            return;
        }
        final Settings closeSettings = updatedSettingsBuilder.build();
        final HashSet<String> removedSettings = Sets.newHashSet();
        for (String key : updatedSettingsBuilder.internalMap().keySet()) {
            if (IndexMetaData.hasDynamicSetting(key)) continue;
            removedSettings.add(key);
        }
        if (!removedSettings.isEmpty()) {
            for (String removedSetting : removedSettings) {
                updatedSettingsBuilder.remove(removedSetting);
            }
        }
        final Settings openSettings = updatedSettingsBuilder.build();
        this.clusterService.submitStateUpdateTask("update-settings", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                try {
                    String[] indices2;
                    Boolean updateReadBlock;
                    Boolean updateWriteBlock;
                    Boolean updateMetaDataBlock;
                    String[] actualIndices = currentState.metaData().concreteIndices(indices);
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder().routingTable(currentState.routingTable());
                    MetaData.Builder metaDataBuilder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", -1);
                    if (updatedNumberOfReplicas != -1) {
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        MetaDataUpdateSettingsService.this.logger.info("updating number_of_replicas to [{}] for indices {}", updatedNumberOfReplicas, actualIndices);
                    }
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    Boolean updatedReadOnly = openSettings.getAsBoolean("index.blocks.read_only", null);
                    if (updatedReadOnly != null) {
                        for (String index : actualIndices) {
                            if (updatedReadOnly.booleanValue()) {
                                blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                                continue;
                            }
                            blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                        }
                    }
                    if ((updateMetaDataBlock = openSettings.getAsBoolean("index.blocks.metadata", null)) != null) {
                        for (String index : actualIndices) {
                            if (updateMetaDataBlock.booleanValue()) {
                                blocks.addIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                                continue;
                            }
                            blocks.removeIndexBlock(index, IndexMetaData.INDEX_METADATA_BLOCK);
                        }
                    }
                    if ((updateWriteBlock = openSettings.getAsBoolean("index.blocks.write", null)) != null) {
                        for (String index : actualIndices) {
                            if (updateWriteBlock.booleanValue()) {
                                blocks.addIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                                continue;
                            }
                            blocks.removeIndexBlock(index, IndexMetaData.INDEX_WRITE_BLOCK);
                        }
                    }
                    if ((updateReadBlock = openSettings.getAsBoolean("index.blocks.read", null)) != null) {
                        for (String index : actualIndices) {
                            if (updateReadBlock.booleanValue()) {
                                blocks.addIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                                continue;
                            }
                            blocks.removeIndexBlock(index, IndexMetaData.INDEX_READ_BLOCK);
                        }
                    }
                    HashSet<String> openIndices = Sets.newHashSet();
                    HashSet<String> closeIndices = Sets.newHashSet();
                    for (String index : actualIndices) {
                        if (currentState.metaData().index(index).state() == IndexMetaData.State.OPEN) {
                            openIndices.add(index);
                            continue;
                        }
                        closeIndices.add(index);
                    }
                    if (!openIndices.isEmpty()) {
                        indices2 = openIndices.toArray(new String[openIndices.size()]);
                        if (!removedSettings.isEmpty()) {
                            MetaDataUpdateSettingsService.this.logger.warn("{} ignoring non dynamic index level settings for open indices: {}", indices2, removedSettings);
                        }
                        metaDataBuilder.updateSettings(openSettings, indices2);
                    }
                    if (!closeIndices.isEmpty()) {
                        indices2 = closeIndices.toArray(new String[closeIndices.size()]);
                        metaDataBuilder.updateSettings(closeSettings, indices2);
                    }
                    ClusterState updatedState = ClusterState.builder().state(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder).blocks(blocks).build();
                    RoutingAllocation.Result routingResult = MetaDataUpdateSettingsService.this.allocationService.reroute(updatedState);
                    updatedState = ClusterState.newClusterStateBuilder().state(updatedState).routingResult(routingResult).build();
                    return updatedState;
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return currentState;
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onSuccess();
            }
        });
    }

    public static interface Listener {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }
}

