/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class InstanceShardOperationRequest
implements ActionRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    protected int shardId = -1;
    private boolean threadedListener = false;

    protected InstanceShardOperationRequest() {
    }

    public InstanceShardOperationRequest(String index) {
        this.index = index;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    InstanceShardOperationRequest index(String index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    @Override
    public InstanceShardOperationRequest listenerThreaded(boolean threadedListener) {
        this.threadedListener = threadedListener;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
        this.shardId = in.readInt();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeInt(this.shardId);
        this.timeout.writeTo(out);
    }

    public void beforeLocalFork() {
    }
}

